/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class BeanPropertyDescriptor {
    protected static Log log = LogFactory.getLog(BeanPropertyDescriptor.class.getName());
    protected PropertyDescriptor myPD = null;
    protected static final Object[] noArgs = new Object[0];

    public BeanPropertyDescriptor(PropertyDescriptor pd) {
        this.myPD = pd;
    }

    protected BeanPropertyDescriptor() {
    }

    public String getName() {
        return this.myPD.getName();
    }

    public boolean isReadable() {
        return this.myPD.getReadMethod() != null;
    }

    public boolean isWriteable() {
        return this.myPD.getWriteMethod() != null;
    }

    public boolean isIndexed() {
        return this.myPD instanceof IndexedPropertyDescriptor;
    }

    public Object get(Object obj) throws InvocationTargetException, IllegalAccessException {
        if (this.myPD.getReadMethod() != null) {
            return this.myPD.getReadMethod().invoke(obj, noArgs);
        }
        throw new IllegalAccessException(Messages.getMessage("badGetter00"));
    }

    public void set(Object obj, Object newValue) throws InvocationTargetException, IllegalAccessException {
        if (this.myPD.getWriteMethod() == null) {
            throw new IllegalAccessException(Messages.getMessage("badSetter00"));
        }
        this.myPD.getWriteMethod().invoke(obj, newValue);
    }

    public Object get(Object obj, int i) throws InvocationTargetException, IllegalAccessException {
        if (!this.isIndexed()) {
            return Array.get(this.get(obj), i);
        }
        IndexedPropertyDescriptor id = (IndexedPropertyDescriptor)this.myPD;
        return id.getIndexedReadMethod().invoke(obj, new Integer(i));
    }

    public void set(Object obj, int i, Object newValue) throws InvocationTargetException, IllegalAccessException {
        if (this.isIndexed()) {
            IndexedPropertyDescriptor id = (IndexedPropertyDescriptor)this.myPD;
            this.growArrayToSize(obj, id.getIndexedPropertyType(), i);
            id.getIndexedWriteMethod().invoke(obj, new Integer(i), newValue);
        } else {
            Array.set(this.get(obj), i, newValue);
        }
    }

    protected void growArrayToSize(Object obj, Class componentType, int i) throws InvocationTargetException, IllegalAccessException {
        Object array = this.get(obj);
        if (array == null || Array.getLength(array) <= i) {
            Object newArray = Array.newInstance(componentType, i + 1);
            if (array != null) {
                System.arraycopy(array, 0, newArray, 0, Array.getLength(array));
            }
            this.set(obj, newArray);
        }
    }

    public Class getType() {
        if (this.isIndexed()) {
            return ((IndexedPropertyDescriptor)this.myPD).getIndexedPropertyType();
        }
        return this.myPD.getPropertyType();
    }
}

