/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SimpleType;
import org.apache.axis.encoding.SimpleValueSerializer;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.BeanUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Types;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SimpleSerializer
implements SimpleValueSerializer {
    public QName xmlType;
    public Class javaType;
    private BeanPropertyDescriptor[] propertyDescriptor = null;
    private TypeDesc typeDesc = null;

    public SimpleSerializer(Class javaType, QName xmlType) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.init();
    }

    public SimpleSerializer(Class javaType, QName xmlType, TypeDesc typeDesc) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.typeDesc = typeDesc;
        this.init();
    }

    private void init() {
        if (SimpleType.class.isAssignableFrom(this.javaType)) {
            if (this.typeDesc == null) {
                this.typeDesc = TypeDesc.getTypeDescForClass(this.javaType);
            }
            this.propertyDescriptor = this.typeDesc != null ? this.typeDesc.getPropertyDescriptors() : BeanUtils.getPd(this.javaType, null);
        }
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        if (value != null && value.getClass() == Object.class) {
            throw new IOException(Messages.getMessage("cantSerialize02"));
        }
        if (value instanceof SimpleType) {
            attributes = this.getObjectAttributes(value, attributes, context);
        }
        context.startElement(name, attributes);
        if (value != null) {
            context.writeSafeString(this.getValueAsString(value, context));
        }
        context.endElement();
    }

    public String getValueAsString(Object value, SerializationContext context) {
        if (value instanceof Float || value instanceof Double) {
            double data = 0.0;
            data = value instanceof Float ? ((Float)value).doubleValue() : ((Double)value).doubleValue();
            if (Double.isNaN(data)) {
                return "NaN";
            }
            if (data == Double.POSITIVE_INFINITY) {
                return "INF";
            }
            if (data == Double.NEGATIVE_INFINITY) {
                return "-INF";
            }
        }
        return value.toString();
    }

    private Attributes getObjectAttributes(Object value, Attributes attributes, SerializationContext context) {
        if (this.typeDesc == null || !this.typeDesc.hasAttributes()) {
            return attributes;
        }
        AttributesImpl attrs = attributes == null ? new AttributesImpl() : (attributes instanceof AttributesImpl ? (AttributesImpl)attributes : new AttributesImpl(attributes));
        try {
            for (int i = 0; i < this.propertyDescriptor.length; ++i) {
                Object propValue;
                FieldDesc field;
                String propName = this.propertyDescriptor[i].getName();
                if (propName.equals("class") || (field = this.typeDesc.getFieldByName(propName)) == null || field.isElement()) continue;
                QName qname = field.getXmlName();
                if (qname == null) {
                    qname = new QName("", propName);
                }
                if (!this.propertyDescriptor[i].isReadable() || this.propertyDescriptor[i].isIndexed() || (propValue = this.propertyDescriptor[i].get(value)) == null) continue;
                String propString = this.getValueAsString(propValue, context);
                String namespace = qname.getNamespaceURI();
                String localName = qname.getLocalPart();
                attrs.addAttribute(namespace, localName, context.qName2String(qname), "CDATA", propString);
            }
        }
        catch (Exception e) {
            return attrs;
        }
        return attrs;
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class javaType, Types types) throws Exception {
        if (!SimpleType.class.isAssignableFrom(javaType)) {
            return null;
        }
        Element complexType = types.createElement("complexType");
        types.writeSchemaElement(this.xmlType, complexType);
        complexType.setAttribute("name", this.xmlType.getLocalPart());
        Element simpleContent = types.createElement("simpleContent");
        complexType.appendChild(simpleContent);
        Element extension = types.createElement("extension");
        simpleContent.appendChild(extension);
        String base = "string";
        for (int i = 0; i < this.propertyDescriptor.length; ++i) {
            String propName = this.propertyDescriptor[i].getName();
            if (!propName.equals("value")) {
                Class fieldType;
                QName qname;
                FieldDesc field;
                if (this.typeDesc == null || (field = this.typeDesc.getFieldByName(propName)) == null) continue;
                if (field.isElement()) {
                    // empty if block
                }
                if ((qname = field.getXmlName()) == null) {
                    qname = new QName("", propName);
                }
                if (!types.isAcceptableAsAttribute(fieldType = this.propertyDescriptor[i].getType())) {
                    throw new AxisFault(Messages.getMessage("AttrNotSimpleType00", propName, fieldType.getName()));
                }
                Element elem = types.createAttributeElement(propName, fieldType, field.getXmlType(), false, extension.getOwnerDocument());
                extension.appendChild(elem);
                continue;
            }
            BeanPropertyDescriptor bpd = this.propertyDescriptor[i];
            Class type = bpd.getType();
            if (!types.isAcceptableAsAttribute(type)) {
                throw new AxisFault(Messages.getMessage("AttrNotSimpleType01", type.getName()));
            }
            base = types.writeType(type);
            extension.setAttribute("base", base);
        }
        return complexType;
    }
}

