/*
 * Decompiled with CFR 0.152.
 */
package iControl;

import iControl.NetworkingInterfaces;
import iControl.NetworkingInterfacesBindingStub;
import iControl.NetworkingInterfacesPortType;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class NetworkingInterfacesLocator
extends Service
implements NetworkingInterfaces {
    private String NetworkingInterfacesPort_address = "https://url_to_service";
    private String NetworkingInterfacesPortWSDDServiceName = "Networking.InterfacesPort";
    private HashSet ports = null;

    public NetworkingInterfacesLocator() {
    }

    public NetworkingInterfacesLocator(EngineConfiguration config) {
        super(config);
    }

    public NetworkingInterfacesLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    public String getNetworkingInterfacesPortAddress() {
        return this.NetworkingInterfacesPort_address;
    }

    public String getNetworkingInterfacesPortWSDDServiceName() {
        return this.NetworkingInterfacesPortWSDDServiceName;
    }

    public void setNetworkingInterfacesPortWSDDServiceName(String name) {
        this.NetworkingInterfacesPortWSDDServiceName = name;
    }

    public NetworkingInterfacesPortType getNetworkingInterfacesPort() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.NetworkingInterfacesPort_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getNetworkingInterfacesPort(endpoint);
    }

    public NetworkingInterfacesPortType getNetworkingInterfacesPort(URL portAddress) throws ServiceException {
        try {
            NetworkingInterfacesBindingStub _stub = new NetworkingInterfacesBindingStub(portAddress, this);
            _stub.setPortName(this.getNetworkingInterfacesPortWSDDServiceName());
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public void setNetworkingInterfacesPortEndpointAddress(String address) {
        this.NetworkingInterfacesPort_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (NetworkingInterfacesPortType.class.isAssignableFrom(serviceEndpointInterface)) {
                NetworkingInterfacesBindingStub _stub = new NetworkingInterfacesBindingStub(new URL(this.NetworkingInterfacesPort_address), this);
                _stub.setPortName(this.getNetworkingInterfacesPortWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("Networking.InterfacesPort".equals(inputPortName)) {
            return this.getNetworkingInterfacesPort();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("urn:iControl", "Networking.Interfaces");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("urn:iControl", "Networking.InterfacesPort"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"NetworkingInterfacesPort".equals(portName)) {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + portName);
        }
        this.setNetworkingInterfacesPortEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

