/*
 * Decompiled with CFR 0.152.
 */
package iControl;

import iControl.NetworkingARP;
import iControl.NetworkingARPBindingStub;
import iControl.NetworkingARPPortType;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class NetworkingARPLocator
extends Service
implements NetworkingARP {
    private String NetworkingARPPort_address = "https://url_to_service";
    private String NetworkingARPPortWSDDServiceName = "Networking.ARPPort";
    private HashSet ports = null;

    public NetworkingARPLocator() {
    }

    public NetworkingARPLocator(EngineConfiguration config) {
        super(config);
    }

    public NetworkingARPLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    public String getNetworkingARPPortAddress() {
        return this.NetworkingARPPort_address;
    }

    public String getNetworkingARPPortWSDDServiceName() {
        return this.NetworkingARPPortWSDDServiceName;
    }

    public void setNetworkingARPPortWSDDServiceName(String name) {
        this.NetworkingARPPortWSDDServiceName = name;
    }

    public NetworkingARPPortType getNetworkingARPPort() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.NetworkingARPPort_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getNetworkingARPPort(endpoint);
    }

    public NetworkingARPPortType getNetworkingARPPort(URL portAddress) throws ServiceException {
        try {
            NetworkingARPBindingStub _stub = new NetworkingARPBindingStub(portAddress, this);
            _stub.setPortName(this.getNetworkingARPPortWSDDServiceName());
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public void setNetworkingARPPortEndpointAddress(String address) {
        this.NetworkingARPPort_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (NetworkingARPPortType.class.isAssignableFrom(serviceEndpointInterface)) {
                NetworkingARPBindingStub _stub = new NetworkingARPBindingStub(new URL(this.NetworkingARPPort_address), this);
                _stub.setPortName(this.getNetworkingARPPortWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("Networking.ARPPort".equals(inputPortName)) {
            return this.getNetworkingARPPort();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("urn:iControl", "Networking.ARP");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("urn:iControl", "Networking.ARPPort"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"NetworkingARPPort".equals(portName)) {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + portName);
        }
        this.setNetworkingARPPortEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

