/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.utils.ClassUtils;

public abstract class BaseFactory {
    protected transient ThreadLocal methodCache = new ThreadLocal();

    private Map getMethodCache() {
        HashMap map = (HashMap)this.methodCache.get();
        if (map == null) {
            map = new HashMap();
            this.methodCache.set(map);
        }
        return map;
    }

    protected Method getMethod(Class clazz, String methodName) {
        String className = clazz.getName();
        Map cache = this.getMethodCache();
        Method method = null;
        if (cache.containsKey(className)) {
            method = (Method)cache.get(clazz);
            return method;
        }
        try {
            method = clazz.getMethod(methodName, String.class, Class.class, QName.class);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (method == null) {
            try {
                Class helper = ClassUtils.forName(clazz.getName() + "_Helper");
                method = helper.getMethod(methodName, String.class, Class.class, QName.class);
            }
            catch (NoSuchMethodException e) {
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        cache.put(className, method);
        return method;
    }
}

