/*
 * Decompiled with CFR 0.152.
 */
package iControl;

import iControl.LocalLBNAT;
import iControl.LocalLBNATBindingStub;
import iControl.LocalLBNATPortType;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class LocalLBNATLocator
extends Service
implements LocalLBNAT {
    private String LocalLBNATPort_address = "https://url_to_service";
    private String LocalLBNATPortWSDDServiceName = "LocalLB.NATPort";
    private HashSet ports = null;

    public LocalLBNATLocator() {
    }

    public LocalLBNATLocator(EngineConfiguration config) {
        super(config);
    }

    public LocalLBNATLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    public String getLocalLBNATPortAddress() {
        return this.LocalLBNATPort_address;
    }

    public String getLocalLBNATPortWSDDServiceName() {
        return this.LocalLBNATPortWSDDServiceName;
    }

    public void setLocalLBNATPortWSDDServiceName(String name) {
        this.LocalLBNATPortWSDDServiceName = name;
    }

    public LocalLBNATPortType getLocalLBNATPort() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.LocalLBNATPort_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getLocalLBNATPort(endpoint);
    }

    public LocalLBNATPortType getLocalLBNATPort(URL portAddress) throws ServiceException {
        try {
            LocalLBNATBindingStub _stub = new LocalLBNATBindingStub(portAddress, this);
            _stub.setPortName(this.getLocalLBNATPortWSDDServiceName());
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public void setLocalLBNATPortEndpointAddress(String address) {
        this.LocalLBNATPort_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (LocalLBNATPortType.class.isAssignableFrom(serviceEndpointInterface)) {
                LocalLBNATBindingStub _stub = new LocalLBNATBindingStub(new URL(this.LocalLBNATPort_address), this);
                _stub.setPortName(this.getLocalLBNATPortWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("LocalLB.NATPort".equals(inputPortName)) {
            return this.getLocalLBNATPort();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("urn:iControl", "LocalLB.NAT");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("urn:iControl", "LocalLB.NATPort"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"LocalLBNATPort".equals(portName)) {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + portName);
        }
        this.setLocalLBNATPortEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

