/**
 * ManagementApplicationServicePortType.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Jan 23, 2013 (02:07:54 PST) WSDL2Java emitter.
 */

package iControl;

public interface ManagementApplicationServicePortType extends java.rmi.Remote {

    /**
     * Adds the metadata for the specified apps.
     *  For definition of the metadata, refer to the get_metadata method
     *  description.
     */
    public void add_metadata(java.lang.String[] apps, java.lang.String[][] names, java.lang.String[][] values) throws java.rmi.RemoteException;

    /**
     * Modifies an existing application service to remove the association
     * with the application template. All objects that were created by the
     * template will continue to be owned by the application service and
     * the
     *  application variables will be preserved. The modify method can be
     * used to reassociate a generic application service with a template.
     */
    public void convert_to_generic(java.lang.String[] apps) throws java.rmi.RemoteException;

    /**
     * Creates a new Application Service. This method first creates
     * a
     *  folder named after the application with a ".app" suffix, then
     *  executes the application template implementation script to create
     * the
     *  objects owned by the application. For example, for an application
     * service named "myapp", and application template named "myapp_tpl",
     * the system creates a folder named "myapp.app" in the current folder,
     * perhaps with a pool and virtual in the new folder, if the
     *  application template script so directs.
     */
    public void create(java.lang.String[] apps, java.lang.String[] templates, iControl.ManagementApplicationServiceScalarVar[][] scalar_vars, iControl.ManagementApplicationServiceListVar[][] list_vars, iControl.ManagementApplicationServiceTableVar[][] table_vars) throws java.rmi.RemoteException;

    /**
     * Creates a new Application Service with extended variables.
     * Extended
     *  variables allows you to specify more than just name and value. This
     * method first creates a folder named after the application with a
     *  ".app" suffix, then executes the application template implementation
     * script to create the objects owned by the application. For example,
     * for an application service named "myapp", and application template
     * named "myapp_tpl", the system creates a folder named "myapp.app" in
     * the current folder, perhaps with a pool and virtual in the new
     *  folder, if the application template script so directs. 
     *  If a variable is marked as encrypted, then the value will be
     *  encrypted by the system.
     */
    public void create_extended(java.lang.String[] apps, java.lang.String[] templates, iControl.ManagementApplicationServiceScalarVarExtended[][] scalar_vars, iControl.ManagementApplicationServiceListVarExtended[][] list_vars, iControl.ManagementApplicationServiceTableVarExtended[][] table_vars) throws java.rmi.RemoteException;

    /**
     * Creates a generic Application service. This method automatically
     * creates a folder named after the application with a ".app" suffix.
     * Any object created in this folder will become owned by the
     *  application.
     */
    public void create_generic(java.lang.String[] apps) throws java.rmi.RemoteException;

    /**
     * Deletes all application services.
     * 
     *  Note: To use this method in 11.4.0 and later, you will need
     *  to use System::Session::set_recursive_query_state to enable
     *  the recursive query/operation state (it applies to delete
     *  as well). This is because the application services reside
     *  in folders below the active folder.
     */
    public void delete_all_application_services() throws java.rmi.RemoteException;

    /**
     * Deletes the specified application services. All objects owned
     * by the
     *   application and the application folder are also deleted.
     */
    public void delete_application_service(java.lang.String[] apps) throws java.rmi.RemoteException;

    /**
     * Gets the descriptions for the the specified application services.
     */
    public java.lang.String[] get_description(java.lang.String[] apps) throws java.rmi.RemoteException;

    /**
     * Gets the name of the device group for the application. Note
     * that if
     *   the keyword "default" was used to set the device group, the value
     * returned here will be the actual name of the device group that was
     * inherited.
     */
    public java.lang.String[] get_device_group(java.lang.String[] apps) throws java.rmi.RemoteException;

    /**
     * Gets the names of all application services. Note that Application
     * Services are always created in a subfolder so if you call get_list
     * immediately after creating an Application Service you will not get
     * the application in the results unless you set the app folder as the
     * active folder or you enable recursive queries.
     */
    public java.lang.String[] get_list() throws java.rmi.RemoteException;

    /**
     * Gets the list variables for the application.
     */
    public iControl.ManagementApplicationServiceListVar[][] get_list_vars(java.lang.String[] apps) throws java.rmi.RemoteException;

    /**
     * Gets the list variables for the application with extended information.
     * If a variable is marked as encrypted, then it has been encrypted by
     * the system.
     */
    public iControl.ManagementApplicationServiceListVarExtended[][] get_list_vars_extended(java.lang.String[] apps) throws java.rmi.RemoteException;

    /**
     * Gets the user metadata for the specified apps.
     *  User metadata, also metadata for short, is mainly a name/value
     *  pair that is associated with a metadata capable config (MCC) object.
     * Some exmaples of MCC objects are ltm pool and virtual server.
     *  The combination of the MCC object name and the metadata name
     *  uniguely identify an instance of the metadata. One MCC object
     *  may have multiple instances of metadata associated with it.
     *  In addition to name/value pair, metadata also has a persistence
     *  attribute. See Common::MetadataPersistence for its definition.
     */
    public java.lang.String[][] get_metadata(java.lang.String[] apps) throws java.rmi.RemoteException;

    /**
     * Gets the metadata descriptions for the specified metadata.
     *  For definition of the metadata, refer to the get_metadata method
     *  description.
     */
    public java.lang.String[][] get_metadata_description(java.lang.String[] apps, java.lang.String[][] names) throws java.rmi.RemoteException;

    /**
     * Gets the persistence for the specified metadata.
     *  For definition of the metadata, refer to the get_metadata method
     *  description.
     */
    public iControl.CommonMetadataPersistence[][] get_metadata_persistence(java.lang.String[] apps, java.lang.String[][] names) throws java.rmi.RemoteException;

    /**
     * Gets the metadata values for the specified metadata.
     *  For definition of the metadata, refer to the get_metadata method
     *  description.
     */
    public java.lang.String[][] get_metadata_value(java.lang.String[] apps, java.lang.String[][] names) throws java.rmi.RemoteException;

    /**
     * Gets the scalar variables for the application.
     */
    public iControl.ManagementApplicationServiceScalarVar[][] get_scalar_vars(java.lang.String[] apps) throws java.rmi.RemoteException;

    /**
     * Gets the scalar variables for the application with extended
     * information.
     *  If a variable is marked as encrypted, then it has been encrypted
     * by
     *   the system.
     */
    public iControl.ManagementApplicationServiceScalarVarExtended[][] get_scalar_vars_extended(java.lang.String[] apps) throws java.rmi.RemoteException;

    /**
     * Gets the state to enforce strict-update checking for a set
     * of
     *  application services.
     */
    public iControl.CommonEnabledState[] get_strict_updates_state(java.lang.String[] apps) throws java.rmi.RemoteException;

    /**
     * Gets the table variables for the application.
     */
    public iControl.ManagementApplicationServiceTableVar[][] get_table_vars(java.lang.String[] apps) throws java.rmi.RemoteException;

    /**
     * Gets the table variables for the application with extended
     * information.
     *  If a variable is marked as encrypted, then it has been encrypted
     * by
     *  the system.
     */
    public iControl.ManagementApplicationServiceTableVarExtended[][] get_table_vars_extended(java.lang.String[] apps) throws java.rmi.RemoteException;

    /**
     * Gets the name of the template used to manage the configuration
     * owned
     *  by the specified application services. If the application does not
     * currently have a template an empty string will be returned.
     */
    public java.lang.String[] get_template(java.lang.String[] apps) throws java.rmi.RemoteException;

    /**
     * Gets the name of the application's traffic group. Note that
     * if
     *   the keyword "default" was used to set the traffic group, the value
     * returned here will be the actual name of the traffic group that was
     * inherited.
     */
    public java.lang.String[] get_traffic_group(java.lang.String[] apps) throws java.rmi.RemoteException;

    /**
     * Gets the version information for this interface.
     */
    public java.lang.String get_version() throws java.rmi.RemoteException;

    /**
     * Gets whether the value returned by get_device_group was inherited
     * from the parent folder.
     */
    public boolean[] is_device_group_inherited(java.lang.String[] apps) throws java.rmi.RemoteException;

    /**
     * Gets a booleann indicating whether the template that was used
     * to create the
     *   application service has been modified and the application service
     * should
     *   be updated using the modify method.
     */
    public boolean[] is_template_modified(java.lang.String[] apps) throws java.rmi.RemoteException;

    /**
     * Gets whether the value returned by get_traffic_group was inherited
     * from the parent folder.
     */
    public boolean[] is_traffic_group_inherited(java.lang.String[] apps) throws java.rmi.RemoteException;

    /**
     * Modifies an existing application service. All existing application
     * variables and values are replaced with the given sets of variables.
     * The application template implementation script is also executed
     *   which may create new objects as directed by the script. Existing
     * objects owned by the application will be deleted if they are not
     *   recreated by the script.
     */
    public void modify(java.lang.String[] apps, java.lang.String[] templates, iControl.ManagementApplicationServiceScalarVar[][] scalar_vars, iControl.ManagementApplicationServiceListVar[][] list_vars, iControl.ManagementApplicationServiceTableVar[][] table_vars) throws java.rmi.RemoteException;

    /**
     * Modifies an existing application service. This causes previous
     * variables to be replaced by any new variables, where specified, and
     * causes the application template implementation script to be rerun,
     * which may create new objects, as directed by the script. Existing
     *   objects owned by the application will be deleted if they are not
     * recreated by the script.
     *  If a variable is marked as encrypted, then it will be encrypted by
     * the system if it is not already. If a variable is to be changed
     *   from encrypted to unencrypted, then a new plain-text value must
     *   also be provided.
     */
    public void modify_extended(java.lang.String[] apps, java.lang.String[] templates, iControl.ManagementApplicationServiceScalarVarExtended[][] scalar_vars, iControl.ManagementApplicationServiceListVarExtended[][] list_vars, iControl.ManagementApplicationServiceTableVarExtended[][] table_vars) throws java.rmi.RemoteException;

    /**
     * Removes all the metadata instances for the specified apps.
     */
    public void remove_all_metadata(java.lang.String[] apps) throws java.rmi.RemoteException;

    /**
     * Removes the metadata for the specified apps and names.
     *  For definition of the metadata, refer to the get_metadata method
     *  description.
     */
    public void remove_metadata(java.lang.String[] apps, java.lang.String[][] names) throws java.rmi.RemoteException;

    /**
     * Sets the descriptions for the the specified application services.
     */
    public void set_description(java.lang.String[] apps, java.lang.String[] values) throws java.rmi.RemoteException;

    /**
     * Set the device group that will be used to sync the application
     * objects to other devices.
     */
    public void set_device_group(java.lang.String[] apps, java.lang.String[] values) throws java.rmi.RemoteException;

    /**
     * Sets the descriptions for the specified metadata.
     *  For definition of the metadata, refer to the get_metadata method
     *  description.
     */
    public void set_metadata_description(java.lang.String[] apps, java.lang.String[][] names, java.lang.String[][] descriptions) throws java.rmi.RemoteException;

    /**
     * Sets the persistence for the specified metadata.
     *  For definition of the metadata, refer to the get_metadata method
     *  description.
     */
    public void set_metadata_persistence(java.lang.String[] apps, java.lang.String[][] names, iControl.CommonMetadataPersistence[][] values) throws java.rmi.RemoteException;

    /**
     * Sets the values for the specified metadata.
     *  For definition of the metadata, refer to the get_metadata method
     *  description.
     */
    public void set_metadata_value(java.lang.String[] apps, java.lang.String[][] names, java.lang.String[][] values) throws java.rmi.RemoteException;

    /**
     * Sets the state to enforce strict-updates checking for the object
     * owned by the application service.
     * 
     *  If set, all modifications made directly to the objects owned by the
     * application will be rejected. All changes must be made by modifying
     * the application variables and executing the appropriate application
     * template action.
     */
    public void set_strict_updates_state(java.lang.String[] apps, iControl.CommonEnabledState[] states) throws java.rmi.RemoteException;

    /**
     * Set the traffic group that will be used for failover with the
     * application services.
     */
    public void set_traffic_group(java.lang.String[] apps, java.lang.String[] values) throws java.rmi.RemoteException;
}
