/**
 * SecurityLogProfilePortType.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Jan 23, 2013 (02:07:54 PST) WSDL2Java emitter.
 */

package iControl;

public interface SecurityLogProfilePortType extends java.rmi.Remote {

    /**
     * Adds a list of Application Security sub-profiles to given logging
     * profiles.
     *  Note: Only one Application Security sub-profile can exist per logging
     * profile.
     */
    public void add_application(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Adds a list of request filters to the existing list in Application
     * Security.
     *  Request filter specifies a fundamental or detailed setting for the
     * type of requests the system, or server logs.
     *  Every request filter has a generic form of key/values.
     *  For consistent configuration, when creating a new request filter
     * with the specified key
     *  you must specify also the values.
     */
    public void add_application_request_filter(java.lang.String[] profile_names, java.lang.String[][] applications, iControl.SecurityLogProfileFilterKey[][][] keys, java.lang.String[][][][] values) throws java.rmi.RemoteException;

    /**
     * Adds a list of values to the request filters in Application
     * Security.
     */
    public void add_application_request_filter_values(java.lang.String[] profile_names, java.lang.String[][] applications, iControl.SecurityLogProfileFilterKey[][][] keys, java.lang.String[][][][] values) throws java.rmi.RemoteException;

    /**
     * Adds a list of IP addresses and ports to the list of remote
     * servers in Application Security.
     *  
     *  Server addresses specify which remote servers log traffic.
     *  You can configure the system to log traffic to multiple remote servers.
     * The default port of the remote machine used to log traffic is 514.
     */
    public void add_application_server_address(java.lang.String[] profile_names, java.lang.String[][] applications, iControl.CommonIPPortDefinition[][][] servers) throws java.rmi.RemoteException;

    /**
     * Adds a list of Network Firewall sub-profiles to given logging
     * profiles.
     *  Note: Only one Network Firewall sub-profile can exist per logging
     * profile.
     */
    public void add_network(java.lang.String[] profile_names, java.lang.String[][] networks) throws java.rmi.RemoteException;

    /**
     * Adds a list of Protocol (DNS) Security sub-profiles to given
     * logging profiles.
     *  Note: Only one Protocol (DNS) Security sub-profile can exist per
     * logging profile.
     */
    public void add_protocol_dns(java.lang.String[] profile_names, java.lang.String[][] dnses) throws java.rmi.RemoteException;

    /**
     * Adds a list of Protocol (SIP) Security sub-profiles to given
     * logging profiles.
     *  Note: Only one Protocol (SIP) Security sub-profile can exist per
     * logging profile.
     */
    public void add_protocol_sip(java.lang.String[] profile_names, java.lang.String[][] sips) throws java.rmi.RemoteException;

    /**
     * Adds a list of Protocol (Transfer) Security sub-profiles to
     * given logging profiles.
     *  Note: Only one Protocol (Transfer) Security sub-profile can exist
     * per logging profile.
     */
    public void add_protocol_transfer(java.lang.String[] profile_names, java.lang.String[][] protocols) throws java.rmi.RemoteException;

    /**
     * Creates the specified logging profiles.
     */
    public void create(java.lang.String[] profile_names) throws java.rmi.RemoteException;

    /**
     * Deletes all logging profiles.
     */
    public void delete_all_log_profiles() throws java.rmi.RemoteException;

    /**
     * Deletes the specified logging profiles.
     */
    public void delete_log_profile(java.lang.String[] profile_names) throws java.rmi.RemoteException;

    /**
     * Gets a list of Application Security sub-profiles for a list
     * of given logging profiles.
     */
    public java.lang.String[][] get_application(java.lang.String[] profile_names) throws java.rmi.RemoteException;

    /**
     * Gets the remote facility in Application Security.
     */
    public iControl.SecurityLogProfileRemoteFacility[][] get_application_facility(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Gets the field delimiter of the predefined storage format in
     * Application Security.
     */
    public java.lang.String[][] get_application_field_delimiter(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Gets the field format of the predefined storage format in Application
     * Security.
     */
    public java.lang.String[][] get_application_field_format(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Gets the fields of the predefined storage format in Application
     * Security.
     */
    public java.lang.String[][][] get_application_fields(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Gets the storage format type in Application Security.
     */
    public iControl.SecurityLogProfileStorageFormat[][] get_application_format(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Gets the guarantee local logging state in Application Security.
     */
    public iControl.CommonEnabledState[][] get_application_guarantee_logging_state(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Gets the guarantee local response logging state in Application
     * Security.
     */
    public iControl.CommonEnabledState[][] get_application_guarantee_response_logging_state(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Gets the local storage state in Application Security.
     */
    public iControl.CommonEnabledState[][] get_application_local_storage_state(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Gets the logic operation in Application Security.
     */
    public iControl.SecurityLogProfileLogicOperation[][] get_application_logic_operation(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Gets the maximum entry length in Application Security.
     */
    public iControl.SecurityLogProfileEntryLength[][] get_application_maximum_entry_length(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Gets the maximum headers size value in Application Security.
     */
    public long[][] get_application_maximum_header_size(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Gets the maximum query string size value in Application Security.
     */
    public long[][] get_application_maximum_query_size(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Gets the maximum request size value in Application Security.
     */
    public long[][] get_application_maximum_request_size(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Gets the remote protocol in Application Security.
     */
    public iControl.SecurityLogProfileRemoteProtocol[][] get_application_protocol(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Gets the remote storage type in Application Security.
     */
    public iControl.SecurityLogProfileRemoteStorage[][] get_application_remote_storage(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Gets the report detected anomalies state in Application Security.
     */
    public iControl.CommonEnabledState[][] get_application_report_anomalies_state(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Gets a list of keys of request (storage) filters in Application
     * Security.
     */
    public iControl.SecurityLogProfileFilterKey[][][] get_application_request_filter_keys(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Gets the values of the request filters in Application Security.
     */
    public java.lang.String[][][][] get_application_request_filter_values(java.lang.String[] profile_names, java.lang.String[][] applications, iControl.SecurityLogProfileFilterKey[][][] keys) throws java.rmi.RemoteException;

    /**
     * Gets the response logging type in Application Security.
     */
    public iControl.SecurityLogProfileResponseLogging[][] get_application_response_logging(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Gets a list of remote servers in Application Security.
     */
    public iControl.CommonIPPortDefinition[][][] get_application_server_address(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Gets the user string of the user-defined storage format in
     * Application Security.
     */
    public java.lang.String[][] get_application_user_string(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Gets the descriptions for a set of logging profiles.
     */
    public java.lang.String[] get_description(java.lang.String[] profile_names) throws java.rmi.RemoteException;

    /**
     * Gets the DNS DoS log publisher in Logging profile.
     */
    public java.lang.String[] get_dns_dos_publisher(java.lang.String[] profile_names) throws java.rmi.RemoteException;

    /**
     * Gets the IP Intelligence log publisher in Logging profile.
     */
    public java.lang.String[] get_ip_intelligence_log_publisher(java.lang.String[] profile_names) throws java.rmi.RemoteException;

    /**
     * Gets the IP Intelligence log translation fields filter state
     * in Logging profile.
     */
    public iControl.CommonEnabledState[] get_ip_intelligence_log_translation_fields_filter_state(java.lang.String[] profile_names) throws java.rmi.RemoteException;

    /**
     * Gets a list of all (security) logging profiles configured in
     * the system.
     */
    public java.lang.String[] get_list() throws java.rmi.RemoteException;

    /**
     * Gets a list of Network Firewall sub-profiles for a list of
     * given logging profiles.
     */
    public java.lang.String[][] get_network(java.lang.String[] profile_names) throws java.rmi.RemoteException;

    /**
     * Gets the field format of the storage format in Network Firewall.
     */
    public java.lang.String[][] get_network_field_format(java.lang.String[] profile_names, java.lang.String[][] networks) throws java.rmi.RemoteException;

    /**
     * Gets the list of fields for the field-list storage format in
     * Network Firewall.
     */
    public java.lang.String[][][] get_network_field_list(java.lang.String[] profile_names, java.lang.String[][] networks) throws java.rmi.RemoteException;

    /**
     * Gets the field-list delimiter of the field-list storage format
     * in Network Firewall.
     */
    public java.lang.String[][] get_network_field_list_delimiter(java.lang.String[] profile_names, java.lang.String[][] networks) throws java.rmi.RemoteException;

    /**
     * Gets the storage format type in Network Firewall.
     */
    public iControl.SecurityLogProfileNetworkStorageFormat[][] get_network_format(java.lang.String[] profile_names, java.lang.String[][] networks) throws java.rmi.RemoteException;

    /**
     * Gets the ACL match accept log filter state in Nework Security.
     */
    public iControl.CommonEnabledState[][] get_network_log_acl_match_accept_filter_state(java.lang.String[] profile_names, java.lang.String[][] networks) throws java.rmi.RemoteException;

    /**
     * Gets the ACL match drop log filter state in Nework Security.
     */
    public iControl.CommonEnabledState[][] get_network_log_acl_match_drop_filter_state(java.lang.String[] profile_names, java.lang.String[][] networks) throws java.rmi.RemoteException;

    /**
     * Gets the ACL match reject log filter state in Nework Security.
     */
    public iControl.CommonEnabledState[][] get_network_log_acl_match_reject_filter_state(java.lang.String[] profile_names, java.lang.String[][] networks) throws java.rmi.RemoteException;

    /**
     * Gets the IP errors log filter state in Nework Security.
     */
    public iControl.CommonEnabledState[][] get_network_log_ip_errors_filter_state(java.lang.String[] profile_names, java.lang.String[][] networks) throws java.rmi.RemoteException;

    /**
     * Gets the log publisher in Network Firewall.
     */
    public java.lang.String[][] get_network_log_publisher(java.lang.String[] profile_names, java.lang.String[][] networks) throws java.rmi.RemoteException;

    /**
     * Gets the TCP errors log filter state in Nework Security.
     */
    public iControl.CommonEnabledState[][] get_network_log_tcp_errors_filter_state(java.lang.String[] profile_names, java.lang.String[][] networks) throws java.rmi.RemoteException;

    /**
     * Gets the TCP events log filter state in Nework Security.
     */
    public iControl.CommonEnabledState[][] get_network_log_tcp_events_filter_state(java.lang.String[] profile_names, java.lang.String[][] networks) throws java.rmi.RemoteException;

    /**
     * Gets the Network log translation fields state in Logging profile.
     */
    public iControl.CommonEnabledState[][] get_network_log_translation_fields_filter_state(java.lang.String[] profile_names, java.lang.String[][] networks) throws java.rmi.RemoteException;

    /**
     * Gets the user defined string of the user-defined storage format
     * in Network Firewall.
     */
    public java.lang.String[][] get_network_user_defined_string(java.lang.String[] profile_names, java.lang.String[][] networks) throws java.rmi.RemoteException;

    /**
     * Gets a list of Protocol (DNS) Security sub-profiles for a list
     * of given logging profiles.
     */
    public java.lang.String[][] get_protocol_dns(java.lang.String[] profile_names) throws java.rmi.RemoteException;

    /**
     * Gets the field format of the storage format in Protocol (DNS)
     * Security.
     */
    public java.lang.String[][] get_protocol_dns_field_format(java.lang.String[] profile_names, java.lang.String[][] dnses) throws java.rmi.RemoteException;

    /**
     * Gets the list of fields for the field-list storage format in
     * Protocol (DNS) Security.
     */
    public java.lang.String[][][] get_protocol_dns_field_list(java.lang.String[] profile_names, java.lang.String[][] dnses) throws java.rmi.RemoteException;

    /**
     * Gets the field-list delimiter of the field-list storage format
     * in Protocol (DNS) Security.
     */
    public java.lang.String[][] get_protocol_dns_field_list_delimiter(java.lang.String[] profile_names, java.lang.String[][] dnses) throws java.rmi.RemoteException;

    /**
     * Gets the storage format type in Protocol (DNS) Security.
     */
    public iControl.SecurityLogProfileDNSStorageFormat[][] get_protocol_dns_format(java.lang.String[] profile_names, java.lang.String[][] dnses) throws java.rmi.RemoteException;

    /**
     * Gets the drop log filter state in Protocol (DNS) Security.
     */
    public iControl.CommonEnabledState[][] get_protocol_dns_log_drop_filter_state(java.lang.String[] profile_names, java.lang.String[][] dnses) throws java.rmi.RemoteException;

    /**
     * Gets the filtered-drop log filter state in Protocol (DNS) Security.
     */
    public iControl.CommonEnabledState[][] get_protocol_dns_log_filtered_drop_filter_state(java.lang.String[] profile_names, java.lang.String[][] dnses) throws java.rmi.RemoteException;

    /**
     * Gets the malformed log filter state in Protocol (DNS) Security.
     */
    public iControl.CommonEnabledState[][] get_protocol_dns_log_malformed_filter_state(java.lang.String[] profile_names, java.lang.String[][] dnses) throws java.rmi.RemoteException;

    /**
     * Gets the malicious log filter state in Protocol (DNS) Security.
     */
    public iControl.CommonEnabledState[][] get_protocol_dns_log_malicious_filter_state(java.lang.String[] profile_names, java.lang.String[][] dnses) throws java.rmi.RemoteException;

    /**
     * Gets the log publisher in Protocol (DNS) Security.
     */
    public java.lang.String[][] get_protocol_dns_log_publisher(java.lang.String[] profile_names, java.lang.String[][] protocols) throws java.rmi.RemoteException;

    /**
     * Gets the DNS-reject log filter state in Protocol (DNS) Security.
     */
    public iControl.CommonEnabledState[][] get_protocol_dns_log_reject_filter_state(java.lang.String[] profile_names, java.lang.String[][] dnses) throws java.rmi.RemoteException;

    /**
     * Gets the user defined string of the user-defined storage format
     * in Protocol (DNS) Security.
     */
    public java.lang.String[][] get_protocol_dns_user_defined_string(java.lang.String[] profile_names, java.lang.String[][] dnses) throws java.rmi.RemoteException;

    /**
     * Gets a list of Protocol (SIP) Security sub-profiles for a list
     * of given logging profiles.
     */
    public java.lang.String[][] get_protocol_sip(java.lang.String[] profile_names) throws java.rmi.RemoteException;

    /**
     * Gets the field format of the predefined storage format in Protocol
     * (SIP) Security.
     */
    public java.lang.String[][] get_protocol_sip_field_format(java.lang.String[] profile_names, java.lang.String[][] sips) throws java.rmi.RemoteException;

    /**
     * Gets the list of fields for the field-list storage format in
     * Protocol (SIP) Security.
     */
    public java.lang.String[][][] get_protocol_sip_field_list(java.lang.String[] profile_names, java.lang.String[][] sips) throws java.rmi.RemoteException;

    /**
     * Gets the field-list delimiter of the field-list storage format
     * in Protocol (SIP) Security.
     */
    public java.lang.String[][] get_protocol_sip_field_list_delimiter(java.lang.String[] profile_names, java.lang.String[][] sips) throws java.rmi.RemoteException;

    /**
     * Gets the storage format type in Protocol (SIP) Security.
     */
    public iControl.SecurityLogProfileSIPStorageFormat[][] get_protocol_sip_format(java.lang.String[] profile_names, java.lang.String[][] sips) throws java.rmi.RemoteException;

    /**
     * Gets the drop log filter state in Protocol (SIP) Security.
     */
    public iControl.CommonEnabledState[][] get_protocol_sip_log_drop_filter_state(java.lang.String[] profile_names, java.lang.String[][] sips) throws java.rmi.RemoteException;

    /**
     * Gets the global-failures log filter state in Protocol (SIP)
     * Security.
     */
    public iControl.CommonEnabledState[][] get_protocol_sip_log_global_failures_filter_state(java.lang.String[] profile_names, java.lang.String[][] sips) throws java.rmi.RemoteException;

    /**
     * Gets the malformed log filter state in Protocol (SIP) Security.
     */
    public iControl.CommonEnabledState[][] get_protocol_sip_log_malformed_filter_state(java.lang.String[] profile_names, java.lang.String[][] sips) throws java.rmi.RemoteException;

    /**
     * Gets the log publisher in Protocol (SIP) Security.
     */
    public java.lang.String[][] get_protocol_sip_log_publisher(java.lang.String[] profile_names, java.lang.String[][] protocols) throws java.rmi.RemoteException;

    /**
     * Gets the redirection-responses log filter state in Protocol
     * (SIP) Security.
     */
    public iControl.CommonEnabledState[][] get_protocol_sip_log_redirection_responses_filter_state(java.lang.String[] profile_names, java.lang.String[][] sips) throws java.rmi.RemoteException;

    /**
     * Gets the request-failures log filter state in Protocol (SIP)
     * Security.
     */
    public iControl.CommonEnabledState[][] get_protocol_sip_log_request_failures_filter_state(java.lang.String[] profile_names, java.lang.String[][] sips) throws java.rmi.RemoteException;

    /**
     * Gets the server-errors log filter state in Protocol (SIP) Security.
     */
    public iControl.CommonEnabledState[][] get_protocol_sip_log_server_errors_filter_state(java.lang.String[] profile_names, java.lang.String[][] sips) throws java.rmi.RemoteException;

    /**
     * Gets the user defined string of the user-defined storage format
     * in Protocol (SIP) Security.
     */
    public java.lang.String[][] get_protocol_sip_user_defined_string(java.lang.String[] profile_names, java.lang.String[][] sips) throws java.rmi.RemoteException;

    /**
     * Gets a list of Protocol (Transfer) Security sub-profiles for
     * a list of given logging profiles.
     */
    public java.lang.String[][] get_protocol_transfer(java.lang.String[] profile_names) throws java.rmi.RemoteException;

    /**
     * Gets the log publisher in Protocol (Transfer) Security.
     */
    public java.lang.String[][] get_protocol_transfer_publisher(java.lang.String[] profile_names, java.lang.String[][] protocols) throws java.rmi.RemoteException;

    /**
     * Gets the SIP DoS log publisher in Logging profile.
     */
    public java.lang.String[] get_sip_dos_publisher(java.lang.String[] profile_names) throws java.rmi.RemoteException;

    /**
     * Gets the version information for this interface.
     */
    public java.lang.String get_version() throws java.rmi.RemoteException;

    /**
     * Determines whether the specified logging profiles are system
     * logging profiles.
     *  A system logging profile is a logging profile pre-configured on the
     * system, ready
     *  for use.  Non-system logging profiles are logging profiles created
     * or modified by a
     *  user.  Note that if a system logging profile is modified, it is no
     * longer
     *  considered a system logging profile (except those ones that explicitly
     * preserved).
     */
    public boolean[] is_system_log_profile(java.lang.String[] profile_names) throws java.rmi.RemoteException;

    /**
     * Removes all request filters in Application Security.
     */
    public void remove_all_application_request_filters(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Removes all remote servers in Application Security.
     */
    public void remove_all_application_server_addresses(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Removes all Application Security sub-profiles from the specified
     * logging profiles.
     */
    public void remove_all_applications(java.lang.String[] profile_names) throws java.rmi.RemoteException;

    /**
     * Removes all Network Firewall sub-profiles from the specified
     * logging profiles.
     */
    public void remove_all_networks(java.lang.String[] profile_names) throws java.rmi.RemoteException;

    /**
     * Removes all Protocol (DNS) Security sub-profiles from the specified
     * logging profiles.
     */
    public void remove_all_protocol_dnses(java.lang.String[] profile_names) throws java.rmi.RemoteException;

    /**
     * Removes all Protocol (SIP) Security sub-profiles from the specified
     * logging profiles.
     */
    public void remove_all_protocol_sips(java.lang.String[] profile_names) throws java.rmi.RemoteException;

    /**
     * Removes all Protocol (Transfer) Security sub-profiles from
     * the specified logging profiles.
     */
    public void remove_all_protocol_transfers(java.lang.String[] profile_names) throws java.rmi.RemoteException;

    /**
     * Removes specific Application Security sub-profiles from the
     * specified logging profiles.
     */
    public void remove_application(java.lang.String[] profile_names, java.lang.String[][] applications) throws java.rmi.RemoteException;

    /**
     * Removes specific request filters from the existing list in
     * Application Security.
     */
    public void remove_application_request_filter(java.lang.String[] profile_names, java.lang.String[][] applications, iControl.SecurityLogProfileFilterKey[][][] keys) throws java.rmi.RemoteException;

    /**
     * Removes specific values from the request filters in Application
     * Security.
     */
    public void remove_application_request_filter_values(java.lang.String[] profile_names, java.lang.String[][] applications, iControl.SecurityLogProfileFilterKey[][][] keys, java.lang.String[][][][] values) throws java.rmi.RemoteException;

    /**
     * Removes specific IP addresses and ports from the list of remote
     * servers in Application Security.
     */
    public void remove_application_server_address(java.lang.String[] profile_names, java.lang.String[][] applications, iControl.CommonIPPortDefinition[][][] servers) throws java.rmi.RemoteException;

    /**
     * Removes specific Network Firewall sub-profiles from the specified
     * logging profiles.
     */
    public void remove_network(java.lang.String[] profile_names, java.lang.String[][] networks) throws java.rmi.RemoteException;

    /**
     * Removes specific Protocol (DNS) Security sub-profiles from
     * the specified logging profiles.
     */
    public void remove_protocol_dns(java.lang.String[] profile_names, java.lang.String[][] dnses) throws java.rmi.RemoteException;

    /**
     * Removes specific Protocol (SIP) Security sub-profiles from
     * the specified logging profiles.
     */
    public void remove_protocol_sip(java.lang.String[] profile_names, java.lang.String[][] sips) throws java.rmi.RemoteException;

    /**
     * Removes specific Protocol (Transfer) Security sub-profiles
     * from the specified logging profiles.
     */
    public void remove_protocol_transfer(java.lang.String[] profile_names, java.lang.String[][] protocols) throws java.rmi.RemoteException;

    /**
     * Replaces the existing fields of the predefined storage format
     * with new ones in Application Security.
     *  This is relevant only for the remote storage of type remote, since
     * Splunk and ArcSight have their fixed format.
     *  
     *  Fields specify which traffic items the server logs, and the order
     * in which the server logs them.
     *  The server displays the items in the log sequentially from the first
     * to the last one.
     */
    public void replace_application_fields(java.lang.String[] profile_names, java.lang.String[][] applications, java.lang.String[][][] fields) throws java.rmi.RemoteException;

    /**
     * Replaces the existing values of the request filters with new
     * ones in Application Security.
     */
    public void replace_application_request_filter_values(java.lang.String[] profile_names, java.lang.String[][] applications, iControl.SecurityLogProfileFilterKey[][][] keys, java.lang.String[][][][] values) throws java.rmi.RemoteException;

    /**
     * Replaces the existing fields of the field-list storage format
     * with new ones in Network Firewall.
     *  This is relevant only for the remote storage of type remote, since
     * Splunk and ArcSight have their fixed format.
     *  
     *  Fields specify which traffic items the server logs, and the order
     * in which the server logs them.
     *  The server displays the items in the log sequentially from the first
     * to the last one.
     */
    public void replace_network_field_list(java.lang.String[] profile_names, java.lang.String[][] networks, java.lang.String[][][] fields) throws java.rmi.RemoteException;

    /**
     * Replaces the existing fields of the field-list storage format
     * with new ones in Protocol (DNS) Security.
     *  This is relevant only for the remote storage of type remote, since
     * Splunk and ArcSight have their fixed format.
     *  
     *  Fields specify which traffic items the server logs, and the order
     * in which the server logs them.
     *  The server displays the items in the log sequentially from the first
     * to the last one.
     */
    public void replace_protocol_dns_field_list(java.lang.String[] profile_names, java.lang.String[][] dnses, java.lang.String[][][] fields) throws java.rmi.RemoteException;

    /**
     * Replaces the existing fields of the field-list storage format
     * with new ones in Protocol (SIP) Security.
     *  This is relevant only for the remote storage of type remote, since
     * Splunk and ArcSight have their fixed format.
     *  
     *  Fields specify which traffic items the server logs, and the order
     * in which the server logs them.
     *  The server displays the items in the log sequentially from the first
     * to the last one.
     */
    public void replace_protocol_sip_field_list(java.lang.String[] profile_names, java.lang.String[][] sips, java.lang.String[][][] fields) throws java.rmi.RemoteException;

    /**
     * Sets the remote facility in Application Security.
     *  The available remote facilities are mentioned under the RemoteFacility
     * enumeration.
     */
    public void set_application_facility(java.lang.String[] profile_names, java.lang.String[][] applications, iControl.SecurityLogProfileRemoteFacility[][] facilities) throws java.rmi.RemoteException;

    /**
     * Sets the field delimiter of the predefined storage format in
     * Application Security.
     *  This is relevant only for the remote storage of type remote, since
     * Splunk and ArcSight have their fixed format.
     *  
     *  Field delimiter specifies which delimiter the remote machine uses
     * to separate the fields in the logging file.
     *  You may not use the % character. The default delimiter is the comma
     * character, for Comma Separated Value (CSV).
     */
    public void set_application_field_delimiter(java.lang.String[] profile_names, java.lang.String[][] applications, java.lang.String[][] texts) throws java.rmi.RemoteException;

    /**
     * Sets the field format of the predefined storage format in Application
     * Security.
     *  This is relevant only for the remote storage of type remote, since
     * Splunk and ArcSight have their fixed format.
     *  
     *  Field format specifies which format the remote machine uses for each
     * key/value pair in the logging file.
     *  Use %k for key and %v for value. The default format is empty that
     * is interpreted as "%v", for CSV.
     */
    public void set_application_field_format(java.lang.String[] profile_names, java.lang.String[][] applications, java.lang.String[][] texts) throws java.rmi.RemoteException;

    /**
     * Sets the storage format type to predefined and replaces the
     * fields in Application Security.
     *  This is relevant only for the remote storage of type remote, since
     * Splunk and ArcSight have their fixed format.
     *  For consistent configuration, when changing the storage format type
     * to predefined you must specify also the fields.
     *  The available storage format types are mentioned under the StorageFormat
     * enumeration.
     *  Please see replace_application_fields for more information about
     * the fields setting.
     */
    public void set_application_format_predefined(java.lang.String[] profile_names, java.lang.String[][] applications, java.lang.String[][][] fields) throws java.rmi.RemoteException;

    /**
     * Sets the storage format type to user-defined and sets the user
     * string in Application Security.
     *  This is relevant only for the remote storage of type remote, since
     * Splunk and ArcSight have their fixed format.
     *  For consistent configuration, when changing the storage format type
     * to user-defined you must specify also the user-string.
     *  The available storage format types are mentioned under the StorageFormat
     * enumeration.
     *  Please see set_application_user_string for more information about
     * every setting.
     */
    public void set_application_format_user_defined(java.lang.String[] profile_names, java.lang.String[][] applications, java.lang.String[][] texts) throws java.rmi.RemoteException;

    /**
     * Sets the guarantee local logging state in Application Security.
     * 
     *  Guarantee local logging specifies:
     *   - When enabled, that the system logs all requests, even though this
     * may slow your virtual server.
     *   - When disabled, that the system logs requests as long as it does
     * not slow your virtual server.
     *  The default is disabled. In either case, the system does not drop
     * requests.
     */
    public void set_application_guarantee_logging_state(java.lang.String[] profile_names, java.lang.String[][] applications, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the guarantee local response logging state in Application
     * Security.
     * 
     *  Guarantee local response logging specifies, when enabled, that the
     * system logs all responses,
     *  even though this may slow your virtual server.
     *  The system may drop requests if the database is too slow to log all
     * responses.
     *  In order to enable this setting, you must first enable guarantee
     * local logging,
     *  and set response logging to either illegal or all requests.
     */
    public void set_application_guarantee_response_logging_state(java.lang.String[] profile_names, java.lang.String[][] applications, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the local storage state in Application Security.
     * 
     *  Local storage specifies, when enabled, that the system stores all
     * traffic in the system
     *  and can be viewed in the Requests screen.
     */
    public void set_application_local_storage_state(java.lang.String[] profile_names, java.lang.String[][] applications, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the logic operation in Application Security.
     *  The available logic operations are mentioned under the LogicOperation
     * enumeration.
     */
    public void set_application_logic_operation(java.lang.String[] profile_names, java.lang.String[][] applications, iControl.SecurityLogProfileLogicOperation[][] operations) throws java.rmi.RemoteException;

    /**
     * Sets the maximum entry length in Application Security.
     *  The available entry lengths are mentioned under the EntryLength enumeration.
     * 
     *  You can change the maximum entry length only for remote servers that
     * support the TCP protocol.
     */
    public void set_application_maximum_entry_length(java.lang.String[] profile_names, java.lang.String[][] applications, iControl.SecurityLogProfileEntryLength[][] lengths) throws java.rmi.RemoteException;

    /**
     * Sets the maximum headers size value in Application Security.
     * 
     *  Maximum headers size specifies how much of the header the server
     * logs.
     *   - Any (zero value): Specifies that the server logs the entire header.
     * This is the default.
     *   - Length in bytes (positive value): Specifies that the server logs
     * headers up to
     *                                       a particular length that you
     * indicate.
     */
    public void set_application_maximum_header_size(java.lang.String[] profile_names, java.lang.String[][] applications, long[][] values) throws java.rmi.RemoteException;

    /**
     * Sets the maximum query string size value in Application Security.
     * 
     *  Maximum query string size specifies how much of the query string
     * the server logs.
     *   - Any (zero value): Specifies that the server logs the entire query
     * string. This is the default.
     *   - Length in bytes (positive value): Specifies that the server logs
     * query strings up to
     *                                       a particular length that you
     * indicate.
     */
    public void set_application_maximum_query_size(java.lang.String[] profile_names, java.lang.String[][] applications, long[][] values) throws java.rmi.RemoteException;

    /**
     * Sets the maximum request size value in Application Security.
     * 
     *  Maximum request size specifies how much of the request the server
     * logs.
     *   - Any (zero value): Specifies that the server logs the entire request.
     * This is the default.
     *   - Length in bytes (positive value): Specifies that the server logs
     * requests up to
     *                                       a particular length that you
     * indicate.
     */
    public void set_application_maximum_request_size(java.lang.String[] profile_names, java.lang.String[][] applications, long[][] values) throws java.rmi.RemoteException;

    /**
     * Sets the remote protocol in Application Security.
     *  The available remote protocols are mentioned under the RemoteProtocol
     * enumeration.
     */
    public void set_application_protocol(java.lang.String[] profile_names, java.lang.String[][] applications, iControl.SecurityLogProfileRemoteProtocol[][] protocols) throws java.rmi.RemoteException;

    /**
     * Sets the remote storage type to remote, storage format type
     * to predefined and replaces the fields in Application Security.
     *  For consistent configuration, when changing the remote storage type
     * to remote (in particular, for the first time)
     *  you must specify also the fields or user-string (for the corresponding
     * format type).
     *  Please see set_application_remote_storage, set_application_format_predefined
     * and replace_application_fields
     *  for more information about every setting.
     */
    public void set_application_remote_format_predefined(java.lang.String[] profile_names, java.lang.String[][] applications, java.lang.String[][][] fields) throws java.rmi.RemoteException;

    /**
     * Sets the remote storage type to remote, storage format type
     * to user-defined and sets the user string in Application Security.
     *  For consistent configuration, when changing the remote storage type
     * to remote (in particular, for the first time)
     *  you must specify also the fields or user-string (for the corresponding
     * format type).
     *  Please see set_application_remote_storage, set_application_format_user_defined
     * and set_application_user_string
     *  for more information about every setting.
     */
    public void set_application_remote_format_user_defined(java.lang.String[] profile_names, java.lang.String[][] applications, java.lang.String[][] texts) throws java.rmi.RemoteException;

    /**
     * Sets the remote storage type in Application Security.
     *  The available remote storage types are mentioned under the RemoteStorage
     * enumeration.
     */
    public void set_application_remote_storage(java.lang.String[] profile_names, java.lang.String[][] applications, iControl.SecurityLogProfileRemoteStorage[][] types) throws java.rmi.RemoteException;

    /**
     * Sets the report detected anomalies state in Application Security.
     * 
     *  Report detected anomalies specifies, when enabled, that the system
     * sends a report string to the
     *  remote system log when a brute force attack, IP enforcer attack,
     * or web scraping attack starts and ends.
     *  The default is disabled.
     */
    public void set_application_report_anomalies_state(java.lang.String[] profile_names, java.lang.String[][] applications, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the response logging type in Application Security.
     *  The available response logging types are mentioned under the ResponseLogging
     * enumeration.
     */
    public void set_application_response_logging(java.lang.String[] profile_names, java.lang.String[][] applications, iControl.SecurityLogProfileResponseLogging[][] types) throws java.rmi.RemoteException;

    /**
     * Sets the user string of the user-defined storage format in
     * Application Security.
     *  This is relevant only for the remote storage of type remote, since
     * Splunk and ArcSight have their fixed format.
     *  
     *  User string specifies the format in which the server logs traffic
     * items.
     *  You can use free text between the traffic items enclosed in % on
     * both sides.
     */
    public void set_application_user_string(java.lang.String[] profile_names, java.lang.String[][] applications, java.lang.String[][] texts) throws java.rmi.RemoteException;

    /**
     * Sets the description for a set of logging profiles.
     * 
     *  This is an arbitrary field which can be used for any purpose.
     */
    public void set_description(java.lang.String[] profile_names, java.lang.String[] descriptions) throws java.rmi.RemoteException;

    /**
     * Sets the DNS DoS log publisher in a Logging profile.
     */
    public void set_dns_dos_publisher(java.lang.String[] profile_names, java.lang.String[] publishers) throws java.rmi.RemoteException;

    /**
     * Sets the IP Intelligence log publisher in a Logging profile.
     */
    public void set_ip_intelligence_log_publisher(java.lang.String[] profile_names, java.lang.String[] publishers) throws java.rmi.RemoteException;

    /**
     * Sets the IP Intelligence log translation fields filter state
     * in a Logging profile.
     *  When enabled, the system logs all translated fields in IP Intelligence
     * logs. Translated fields include
     *  Source Address/Port, Destination Address/Port, IP Protocol, Route
     * Domain, Vlan, Source Address
     *  translation reason and Source Address translation Pool.
     *  When disabled, the system does not log the translated fields. The
     * default is disabled.
     */
    public void set_ip_intelligence_log_translation_fields_filter_state(java.lang.String[] profile_names, iControl.CommonEnabledState[] states) throws java.rmi.RemoteException;

    /**
     * Sets the field format of the storage format in Network Firewall.
     * This is relevant only for the remote storage of type remote, since
     * Splunk and ArcSight have their fixed format.
     * 
     *  Field format specifies which format the remote machine uses for each
     * key/value pair in the logging file.
     *  Use %k for key and %v for value. The default format is empty that
     * is interpreted as "%v", for CSV.
     */
    public void set_network_field_format(java.lang.String[] profile_names, java.lang.String[][] networks, java.lang.String[][] texts) throws java.rmi.RemoteException;

    /**
     * Sets the field-list delimiter of the field-list storage format
     * in Network Firewall.
     *  
     *  Field delimiter specifies which delimiter the remote machine uses
     * to separate the fields in the logging file.
     *  You may not use the % character. The default delimiter is the comma
     * character, for Comma Separated Value (CSV).
     */
    public void set_network_field_list_delimiter(java.lang.String[] profile_names, java.lang.String[][] networks, java.lang.String[][] texts) throws java.rmi.RemoteException;

    /**
     * Sets the storage format type to field list and sets the fields
     * list in Network Firewall.
     *  For consistent configuration, when changing the storage format type
     * to field list one must specify also the fields list.
     *  The available storage format types are mentioned under the NetworkStorageFormat
     * enumeration.
     *  Please see replace_network_field_list for more information about
     * the field list setting.
     */
    public void set_network_format_field_list(java.lang.String[] profile_names, java.lang.String[][] networks, java.lang.String[][][] fields) throws java.rmi.RemoteException;

    /**
     * Sets the storage format type to user-defined and sets the user-defined
     * string in Network Firewall.
     *  For consistent configuration, when changing the storage format type
     * to user-defined one must specify also
     *  the user-defined string.
     *  The available storage format types are mentioned under the NetworkStorageFormat
     * enumeration.
     *  Please see set_network_user_defined_string for more information about
     * every setting.
     */
    public void set_network_format_user_defined(java.lang.String[] profile_names, java.lang.String[][] networks, java.lang.String[][] texts) throws java.rmi.RemoteException;

    /**
     * Sets the ACL match accept log filter state in Network Firewall.
     * When enabled, the system logs all requests that are accepted due to
     * an ACL match. When disabled, the system does not log.
     *  The default is disabled.
     */
    public void set_network_log_acl_match_accept_filter_state(java.lang.String[] profile_names, java.lang.String[][] networks, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the ACL match drop log filter state in Network Firewall.
     * When enabled, the system logs all requests that are dropped due to
     * an ACL match. When disabled, the system does not log.
     *  The default is disabled.
     */
    public void set_network_log_acl_match_drop_filter_state(java.lang.String[] profile_names, java.lang.String[][] networks, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the ACL match reject log filter state in Network Firewall.
     * When enabled, the system logs all requests that are rejected due to
     * an ACL match. When disabled, the system does not log.
     *  The default is disabled.
     */
    public void set_network_log_acl_match_reject_filter_state(java.lang.String[] profile_names, java.lang.String[][] networks, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the IP errors log filter state in Network Firewall.
     *  When enabled, the system logs all IP errors (eg. IP error checksum).
     * When disabled, the system does not log any IP errors. The default
     * is disabled.
     */
    public void set_network_log_ip_errors_filter_state(java.lang.String[] profile_names, java.lang.String[][] networks, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the log publisher in Network Firewall.
     *  The publisher name is the only configuration in this sub-profile
     *  that encapsulates all remote logging settings in a generic way.
     *  Please see the Publisher interface in the Log module for more information.
     */
    public void set_network_log_publisher(java.lang.String[] profile_names, java.lang.String[][] networks, java.lang.String[][] publishers) throws java.rmi.RemoteException;

    /**
     * Sets the TCP errors log filter state in Network Firewall.
     *  When enabled, the system logs all TCP errors (eg. BAD TCP checksum).
     * When disabled, the system does not log any TCP errors.
     *  The default is disabled.
     */
    public void set_network_log_tcp_errors_filter_state(java.lang.String[] profile_names, java.lang.String[][] networks, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the TCP events log filter state in Network Firewall.
     *  When enabled, the system logs all TCP connection established and
     * closed events.
     *  When disabled, the system does not log any TCP event. The default
     * is disabled.
     */
    public void set_network_log_tcp_events_filter_state(java.lang.String[] profile_names, java.lang.String[][] networks, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the Network log translation fields filter state in a Logging
     * profile.
     *  When enabled, the system logs all translated fields in Network logs.
     * Translated fields include
     *  Source Address/Port, Destination Address/Port, IP Protocol, Route
     * Domain, Vlan, Source Address
     *  translation reason and Source Address translation Pool.
     *  When disabled, the system does not log the translated fields. The
     * default is disabled.
     */
    public void set_network_log_translation_fields_filter_state(java.lang.String[] profile_names, java.lang.String[][] networks, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the user defined string of the user-defined storage format
     * in Network Firewall.
     *  
     *  You can use free text between the traffic items enclosed in % on
     * both sides.
     */
    public void set_network_user_defined_string(java.lang.String[] profile_names, java.lang.String[][] networks, java.lang.String[][] texts) throws java.rmi.RemoteException;

    /**
     * Sets the field format of the storage format in Protocol (DNS)
     * Security.
     *  This is relevant only for the remote storage of type remote, since
     * Splunk and ArcSight have their fixed format.
     * 
     *  Field format specifies which format the remote machine uses for each
     * key/value pair in the logging file.
     *  Use %k for key and %v for value. The default format is empty that
     * is interpreted as "%v", for CSV.
     */
    public void set_protocol_dns_field_format(java.lang.String[] profile_names, java.lang.String[][] dnses, java.lang.String[][] texts) throws java.rmi.RemoteException;

    /**
     * Sets the field-list delimiter of the field-list storage format
     * in Protocol (DNS) Security.
     *  
     *  Field delimiter specifies which delimiter the remote machine uses
     * to separate the fields in the logging file.
     *  You may not use the % character. The default delimiter is the comma
     * character, for Comma Separated Value (CSV).
     */
    public void set_protocol_dns_field_list_delimiter(java.lang.String[] profile_names, java.lang.String[][] dnses, java.lang.String[][] texts) throws java.rmi.RemoteException;

    /**
     * Sets the storage format type to field list and sets the fields
     * list in Protocol (DNS) Security.
     *  For consistent configuration, when changing the storage format type
     * to field list one must specify also the fields list.
     *  The available storage format types are mentioned under the DNSStorageFormat
     * enumeration.
     *  Please see replace_protocol_dns_field_list for more information about
     * the field list setting.
     */
    public void set_protocol_dns_format_field_list(java.lang.String[] profile_names, java.lang.String[][] dnses, java.lang.String[][][] fields) throws java.rmi.RemoteException;

    /**
     * Sets the storage format type to user-defined and sets the user-defined
     * string in Protocol (DNS) Security.
     *  For consistent configuration, when changing the storage format type
     * to user-defined one must specify also
     *  the user-defined string.
     *  The available storage format types are mentioned under the DNSStorageFormat
     * enumeration.
     *  Please see set_protocol_dns_user_defined_string for more information
     * about every setting.
     */
    public void set_protocol_dns_format_user_defined(java.lang.String[] profile_names, java.lang.String[][] dnses, java.lang.String[][] texts) throws java.rmi.RemoteException;

    /**
     * Sets the drop log filter state in Protocol (DNS) Security.
     *  When enabled, the system logs all DNS requests that are dropped.
     * When disabled, the system does not log.
     *  The default is disabled.
     */
    public void set_protocol_dns_log_drop_filter_state(java.lang.String[] profile_names, java.lang.String[][] dnses, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the filtered-drop log filter state in Protocol (DNS) Security.
     * When enabled, the system logs all DNS requests that are dropped due
     * to security filtering.
     *  When disabled, the system does not log. The default is disabled.
     */
    public void set_protocol_dns_log_filtered_drop_filter_state(java.lang.String[] profile_names, java.lang.String[][] dnses, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the malformed log filter state in Protocol (DNS) Security.
     * When enabled, the system logs all DNS requests that are malformed.
     * When disabled, the system does not log.
     *  The default is disabled.
     */
    public void set_protocol_dns_log_malformed_filter_state(java.lang.String[] profile_names, java.lang.String[][] dnses, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the malicious log filter state in Protocol (DNS) Security.
     * When enabled, the system logs all DNS requests that are malicious.
     * When disabled, the system does not log.
     *  The default is disabled.
     */
    public void set_protocol_dns_log_malicious_filter_state(java.lang.String[] profile_names, java.lang.String[][] dnses, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the log publisher in Protocol (DNS) Security.
     *  The publisher name is the only configuration in this sub-profile
     *  that encapsulates all remote logging settings in a generic way.
     *  Please see the Publisher interface in the Log module for more information.
     */
    public void set_protocol_dns_log_publisher(java.lang.String[] profile_names, java.lang.String[][] protocols, java.lang.String[][] publishers) throws java.rmi.RemoteException;

    /**
     * Sets the DNS-reject log filter state in Protocol (DNS) Security.
     * When enabled, the system logs all DNS requests that are rejected.
     * When disabled, the system does not log.
     *  The default is disabled.
     */
    public void set_protocol_dns_log_reject_filter_state(java.lang.String[] profile_names, java.lang.String[][] dnses, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the user defined string of the user-defined storage format
     * in Protocol (DNS) Security.
     *  
     *  You can use free text between the traffic items enclosed in % on
     * both sides.
     */
    public void set_protocol_dns_user_defined_string(java.lang.String[] profile_names, java.lang.String[][] dnses, java.lang.String[][] texts) throws java.rmi.RemoteException;

    /**
     * Sets the field format of the predefined storage format in Protocol
     * (SIP) Security.
     *  This is relevant only for the remote storage of type remote, since
     * Splunk and ArcSight have their fixed format.
     * 
     *  Field format specifies which format the remote machine uses for each
     * key/value pair in the logging file.
     *  Use %k for key and %v for value. The default format is empty that
     * is interpreted as "%v", for CSV.
     */
    public void set_protocol_sip_field_format(java.lang.String[] profile_names, java.lang.String[][] sips, java.lang.String[][] texts) throws java.rmi.RemoteException;

    /**
     * Sets the field-list delimiter of the field-list storage format
     * in Protocol (SIP) Security.
     *  
     *  Field delimiter specifies which delimiter the remote machine uses
     * to separate the fields in the logging file.
     *  You may not use the % character. The default delimiter is the comma
     * character, for Comma Separated Value (CSV).
     */
    public void set_protocol_sip_field_list_delimiter(java.lang.String[] profile_names, java.lang.String[][] sips, java.lang.String[][] texts) throws java.rmi.RemoteException;

    /**
     * Sets the storage format type to field list and sets the fields
     * list in Protocol (SIP) Security.
     *  For consistent configuration, when changing the storage format type
     * to field list one must specify also the fields list.
     *  The available storage format types are mentioned under the SIPStorageFormat
     * enumeration.
     *  Please see replace_protocol_sip_field_list for more information about
     * the field list setting.
     */
    public void set_protocol_sip_format_field_list(java.lang.String[] profile_names, java.lang.String[][] sips, java.lang.String[][][] fields) throws java.rmi.RemoteException;

    /**
     * Sets the storage format type to user-defined and sets the user-defined
     * string in Protocol (SIP) Security.
     *  For consistent configuration, when changing the storage format type
     * to user-defined one must specify also 
     *  the user-defined string.
     *  The available storage format types are mentioned under the SIPStorageFormat
     * enumeration.
     *  Please see set_protocol_sip_user_defined_string for more information
     * about every setting.
     */
    public void set_protocol_sip_format_user_defined(java.lang.String[] profile_names, java.lang.String[][] sips, java.lang.String[][] texts) throws java.rmi.RemoteException;

    /**
     * Sets the drop log filter state in Protocol (SIP) Security.
     *  When enabled, the system logs all SIP requests that are dropped.
     * When disabled, the system does not log.
     *  The default is disabled.
     */
    public void set_protocol_sip_log_drop_filter_state(java.lang.String[] profile_names, java.lang.String[][] sips, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the global-failures log filter state in Protocol (SIP)
     * Security.
     *  When enabled, the system logs all SIP requests that failed due to
     * global failures (all 6XX response codes).
     *  When disabled, the system does not log. The default is disabled.
     */
    public void set_protocol_sip_log_global_failures_filter_state(java.lang.String[] profile_names, java.lang.String[][] sips, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the malformed log filter state in Protocol (SIP) Security.
     * When enabled, the system logs all SIP requests that are malformed.
     * When disabled, the system does not log.
     *  The default is disabled.
     */
    public void set_protocol_sip_log_malformed_filter_state(java.lang.String[] profile_names, java.lang.String[][] sips, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the log publisher in Protocol (SIP) Security.
     *  The publisher name is the only configuration in this sub-profile
     *  that encapsulates all remote logging settings in a generic way.
     *  Please see the Publisher interface in the Log module for more information.
     */
    public void set_protocol_sip_log_publisher(java.lang.String[] profile_names, java.lang.String[][] protocols, java.lang.String[][] publishers) throws java.rmi.RemoteException;

    /**
     * Sets the redirection-responses log filter state in Protocol
     * (SIP) Security.
     *  When enabled, the system logs all SIP requests that result in redirection
     * responses (all 3XX response codes).
     *  When disabled, the system does not log. The default is disabled.
     */
    public void set_protocol_sip_log_redirection_responses_filter_state(java.lang.String[] profile_names, java.lang.String[][] sips, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the request-failures log filter state in Protocol (SIP)
     * Security.
     *  When enabled, the system logs all SIP requests that failed (all 4XX
     * response codes).
     *  When disabled, the system does not log. The default is disabled.
     */
    public void set_protocol_sip_log_request_failures_filter_state(java.lang.String[] profile_names, java.lang.String[][] sips, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the server-errors log filter state in Protocol (SIP) Security.
     * When enabled, the system logs all SIP requests that failed due to
     * server errors (all 5XX response codes).
     *  When disabled, the system does not log. The default is disabled.
     */
    public void set_protocol_sip_log_server_errors_filter_state(java.lang.String[] profile_names, java.lang.String[][] sips, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the user defined string of the user-defined storage format
     * in Protocol (SIP) Security.
     *  
     *  You can use free text between the traffic items enclosed in % on
     * both sides.
     */
    public void set_protocol_sip_user_defined_string(java.lang.String[] profile_names, java.lang.String[][] sips, java.lang.String[][] texts) throws java.rmi.RemoteException;

    /**
     * Sets the log publisher in Protocol (Transfer) Security.
     *  The publisher name is the only configuration in this sub-profile
     *  that encapsulates all remote logging settings in a generic way.
     *  Please see the Publisher interface in the Log module for more information.
     */
    public void set_protocol_transfer_publisher(java.lang.String[] profile_names, java.lang.String[][] protocols, java.lang.String[][] publishers) throws java.rmi.RemoteException;

    /**
     * Sets the SIP DoS log publisher in a Logging profile.
     */
    public void set_sip_dos_publisher(java.lang.String[] profile_names, java.lang.String[] publishers) throws java.rmi.RemoteException;
}
