/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtils {
    public static final String lineSeparator = System.getProperty("line.separator", "\n");
    public static final String lineSeparatorStr = StringUtils.cleanString(lineSeparator);

    public static String cleanString(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                default: {
                    stringBuffer.append(cArray[n]);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String getClassName(Class clazz) {
        String string = clazz.getName();
        return clazz.isArray() ? StringUtils.parseDescriptor(string) : string;
    }

    private static String parseDescriptor(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (cArray[n2] == '[') {
            ++n;
            ++n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        switch (cArray[n2++]) {
            case 'B': {
                stringBuffer.append("byte");
                break;
            }
            case 'C': {
                stringBuffer.append("char");
                break;
            }
            case 'D': {
                stringBuffer.append("double");
                break;
            }
            case 'F': {
                stringBuffer.append("float");
                break;
            }
            case 'I': {
                stringBuffer.append("int");
                break;
            }
            case 'J': {
                stringBuffer.append("long");
                break;
            }
            case 'S': {
                stringBuffer.append("short");
                break;
            }
            case 'Z': {
                stringBuffer.append("boolean");
                break;
            }
            case 'L': {
                stringBuffer.append(cArray, n2, cArray.length - n2 - 1);
            }
        }
        n2 = 0;
        while (n2 < n) {
            stringBuffer.append("[]");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static URL getURL(URL uRL, String string) throws MalformedURLException {
        File file;
        if (uRL != null && (file = new File(string)).isAbsolute()) {
            return file.toURL();
        }
        try {
            return new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            if (uRL == null) {
                return new File(string).toURL();
            }
            throw malformedURLException;
        }
    }

    public static InputStream getContentAsInputStream(URL uRL) throws SecurityException, IllegalArgumentException, IOException {
        if (uRL == null) {
            throw new IllegalArgumentException("URL cannot be null.");
        }
        try {
            Object object = uRL.getContent();
            if (object == null) {
                throw new IllegalArgumentException("No content.");
            }
            if (object instanceof InputStream) {
                return (InputStream)object;
            }
            throw new IllegalArgumentException(object instanceof String ? (String)object : "This URL points to a: " + StringUtils.getClassName(object.getClass()));
        }
        catch (SecurityException securityException) {
            throw new SecurityException("Your JVM's SecurityManager has disallowed this.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("This file was not found: " + uRL);
        }
    }

    public static List parseNMTokens(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        return vector;
    }

    public static String getNMTokens(List list) {
        if (list != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)list.get(n2);
                stringBuffer.append((n2 > 0 ? " " : "") + string);
                ++n2;
            }
            return stringBuffer.toString();
        }
        return null;
    }
}

