/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.symbolTable;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.IntHolder;
import org.apache.axis.Constants;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.symbolTable.Utils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaUtils {
    static final QName VALUE_QNAME = Utils.findQName("", "value");
    private static String[] schemaTypes = new String[]{"string", "normalizedString", "token", "byte", "unsignedByte", "base64Binary", "hexBinary", "integer", "positiveInteger", "negativeInteger", "nonNegativeInteger", "nonPositiveInteger", "int", "unsignedInt", "long", "unsignedLong", "short", "unsignedShort", "decimal", "float", "double", "boolean", "time", "dateTime", "duration", "date", "gMonth", "gYear", "gYearMonth", "gDay", "gMonthDay", "Name", "QName", "NCName", "anyURI", "language", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NOTATION", "NMTOKEN", "NMTOKENS"};
    private static final Set schemaTypeSet = new HashSet<String>(Arrays.asList(schemaTypes));

    public static Vector getContainedElementDeclarations(Node node, SymbolTable symbolTable) {
        Type simpleType;
        NodeList children;
        if (node == null) {
            return null;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node kid = children.item(j);
                if (!SchemaUtils.isXSDNode(kid, "complexType")) continue;
                node = kid;
                break;
            }
        }
        if (SchemaUtils.isXSDNode(node, "complexType")) {
            Node kid;
            int j;
            children = node.getChildNodes();
            Node complexContent = null;
            Node simpleContent = null;
            Node extension = null;
            for (j = 0; j < children.getLength(); ++j) {
                kid = children.item(j);
                if (SchemaUtils.isXSDNode(kid, "complexContent")) {
                    complexContent = kid;
                    break;
                }
                if (!SchemaUtils.isXSDNode(kid, "simpleContent")) continue;
                simpleContent = kid;
            }
            if (complexContent != null) {
                children = complexContent.getChildNodes();
                for (j = 0; j < children.getLength() && extension == null; ++j) {
                    kid = children.item(j);
                    if (!SchemaUtils.isXSDNode(kid, "extension")) continue;
                    extension = kid;
                }
            }
            if (simpleContent != null) {
                children = simpleContent.getChildNodes();
                for (j = 0; j < children.getLength() && extension == null; ++j) {
                    QName extensionOrRestrictionKind = Utils.getNodeQName(children.item(j));
                    if (extensionOrRestrictionKind == null || !extensionOrRestrictionKind.getLocalPart().equals("extension") && !extensionOrRestrictionKind.getLocalPart().equals("restriction") || !Constants.isSchemaXSD(extensionOrRestrictionKind.getNamespaceURI())) continue;
                    QName extendsOrRestrictsType = Utils.getTypeQName(children.item(j), new BooleanHolder(), false);
                    Vector<ElementDecl> v = new Vector<ElementDecl>();
                    ElementDecl elem = new ElementDecl();
                    elem.setType(symbolTable.getTypeEntry(extendsOrRestrictsType, false));
                    elem.setName(VALUE_QNAME);
                    v.add(elem);
                    return v;
                }
            }
            if (extension != null) {
                node = extension;
            }
            children = node.getChildNodes();
            Vector v = new Vector();
            for (int j2 = 0; j2 < children.getLength(); ++j2) {
                QName subNodeKind = Utils.getNodeQName(children.item(j2));
                if (subNodeKind == null || !Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) continue;
                if (subNodeKind.getLocalPart().equals("sequence")) {
                    v.addAll(SchemaUtils.processSequenceNode(children.item(j2), symbolTable));
                    continue;
                }
                if (subNodeKind.getLocalPart().equals("all")) {
                    v.addAll(SchemaUtils.processAllNode(children.item(j2), symbolTable));
                    continue;
                }
                if (subNodeKind.getLocalPart().equals("choice")) {
                    v.addAll(SchemaUtils.processChoiceNode(children.item(j2), symbolTable));
                    continue;
                }
                if (!subNodeKind.getLocalPart().equals("group")) continue;
                v.addAll(SchemaUtils.processGroupNode(children.item(j2), symbolTable));
            }
            return v;
        }
        QName simpleQName = SchemaUtils.getSimpleTypeBase(node);
        if (simpleQName != null && (simpleType = symbolTable.getType(simpleQName)) != null) {
            Vector<ElementDecl> v = new Vector<ElementDecl>();
            ElementDecl elem = new ElementDecl();
            elem.setType(simpleType);
            elem.setName(new QName("", "value"));
            v.add(elem);
            return v;
        }
        return null;
    }

    private static Vector processChoiceNode(Node choiceNode, SymbolTable symbolTable) {
        Vector<ElementDecl> v = new Vector<ElementDecl>();
        NodeList children = choiceNode.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            ElementDecl elem;
            QName subNodeKind = Utils.getNodeQName(children.item(j));
            if (subNodeKind == null || !Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) continue;
            if (subNodeKind.getLocalPart().equals("choice")) {
                v.addAll(SchemaUtils.processChoiceNode(children.item(j), symbolTable));
                continue;
            }
            if (subNodeKind.getLocalPart().equals("sequence")) {
                v.addAll(SchemaUtils.processSequenceNode(children.item(j), symbolTable));
                continue;
            }
            if (subNodeKind.getLocalPart().equals("group")) {
                v.addAll(SchemaUtils.processGroupNode(children.item(j), symbolTable));
                continue;
            }
            if (!subNodeKind.getLocalPart().equals("element") || (elem = SchemaUtils.processChildElementNode(children.item(j), symbolTable)) == null) continue;
            v.add(elem);
        }
        return v;
    }

    private static Vector processSequenceNode(Node sequenceNode, SymbolTable symbolTable) {
        Vector<ElementDecl> v = new Vector<ElementDecl>();
        NodeList children = sequenceNode.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            ElementDecl elem;
            QName subNodeKind = Utils.getNodeQName(children.item(j));
            if (subNodeKind == null || !Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) continue;
            if (subNodeKind.getLocalPart().equals("choice")) {
                v.addAll(SchemaUtils.processChoiceNode(children.item(j), symbolTable));
                continue;
            }
            if (subNodeKind.getLocalPart().equals("sequence")) {
                v.addAll(SchemaUtils.processSequenceNode(children.item(j), symbolTable));
                continue;
            }
            if (subNodeKind.getLocalPart().equals("group")) {
                v.addAll(SchemaUtils.processGroupNode(children.item(j), symbolTable));
                continue;
            }
            if (subNodeKind.getLocalPart().equals("any")) {
                Type type = symbolTable.getType(Constants.XSD_ANY);
                ElementDecl elem2 = new ElementDecl(type, Utils.findQName("", "any"));
                elem2.setAnyElement(true);
                v.add(elem2);
                continue;
            }
            if (!subNodeKind.getLocalPart().equals("element") || (elem = SchemaUtils.processChildElementNode(children.item(j), symbolTable)) == null) continue;
            v.add(elem);
        }
        return v;
    }

    private static Vector processGroupNode(Node groupNode, SymbolTable symbolTable) {
        Vector v = new Vector();
        NodeList children = groupNode.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            QName subNodeKind = Utils.getNodeQName(children.item(j));
            if (subNodeKind == null || !Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) continue;
            if (subNodeKind.getLocalPart().equals("choice")) {
                v.addAll(SchemaUtils.processChoiceNode(children.item(j), symbolTable));
                continue;
            }
            if (subNodeKind.getLocalPart().equals("sequence")) {
                v.addAll(SchemaUtils.processSequenceNode(children.item(j), symbolTable));
                continue;
            }
            if (!subNodeKind.getLocalPart().equals("all")) continue;
            v.addAll(SchemaUtils.processAllNode(children.item(j), symbolTable));
        }
        return v;
    }

    private static Vector processAllNode(Node allNode, SymbolTable symbolTable) {
        Vector<ElementDecl> v = new Vector<ElementDecl>();
        NodeList children = allNode.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            ElementDecl elem;
            Node kid = children.item(j);
            if (!SchemaUtils.isXSDNode(kid, "element") || (elem = SchemaUtils.processChildElementNode(kid, symbolTable)) == null) continue;
            v.add(elem);
        }
        return v;
    }

    private static ElementDecl processChildElementNode(Node elementNode, SymbolTable symbolTable) {
        QName nodeName = Utils.getNodeNameQName(elementNode);
        BooleanHolder forElement = new BooleanHolder();
        QName nodeType = Utils.getTypeQName(elementNode, forElement, false);
        TypeEntry type = symbolTable.getTypeEntry(nodeType, forElement.value);
        if (!forElement.value) {
            String def;
            String form = Utils.getAttribute(elementNode, "form");
            if (form != null && form.equals("unqualified")) {
                nodeName = Utils.findQName("", nodeName.getLocalPart());
            } else if (form == null && ((def = Utils.getScopedAttribute(elementNode, "elementFormDefault")) == null || def.equals("unqualified"))) {
                nodeName = Utils.findQName("", nodeName.getLocalPart());
            }
        }
        if (type != null) {
            ElementDecl elem = new ElementDecl(type, nodeName);
            String minOccurs = Utils.getAttribute(elementNode, "minOccurs");
            if (minOccurs != null && minOccurs.equals("0")) {
                elem.setMinOccursIs0(true);
            }
            return elem;
        }
        return null;
    }

    public static QName getElementAnonQName(Node node) {
        if (SchemaUtils.isXSDNode(node, "element")) {
            NodeList children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node kid = children.item(j);
                if (!SchemaUtils.isXSDNode(kid, "complexType") && !SchemaUtils.isXSDNode(kid, "simpleType")) continue;
                return Utils.getNodeNameQName(kid);
            }
        }
        return null;
    }

    public static QName getAttributeAnonQName(Node node) {
        if (SchemaUtils.isXSDNode(node, "attribute")) {
            NodeList children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node kid = children.item(j);
                if (!SchemaUtils.isXSDNode(kid, "complexType") && !SchemaUtils.isXSDNode(kid, "simpleType")) continue;
                return Utils.getNodeNameQName(kid);
            }
        }
        return null;
    }

    public static boolean isSimpleTypeOrSimpleContent(Node node) {
        NodeList children;
        if (node == null) {
            return false;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node kid = children.item(j);
                if (SchemaUtils.isXSDNode(kid, "complexType")) {
                    node = kid;
                    break;
                }
                if (!SchemaUtils.isXSDNode(kid, "simpleType")) continue;
                return true;
            }
        }
        if (SchemaUtils.isXSDNode(node, "simpleType")) {
            return true;
        }
        if (SchemaUtils.isXSDNode(node, "complexType")) {
            children = node.getChildNodes();
            Node complexContent = null;
            Node simpleContent = null;
            for (int j = 0; j < children.getLength(); ++j) {
                Node kid = children.item(j);
                if (SchemaUtils.isXSDNode(kid, "complexContent")) {
                    complexContent = kid;
                    break;
                }
                if (!SchemaUtils.isXSDNode(kid, "simpleContent")) continue;
                simpleContent = kid;
            }
            if (complexContent != null) {
                return false;
            }
            if (simpleContent != null) {
                return true;
            }
        }
        return false;
    }

    private static boolean isXSDNode(Node node, String schemaLocalName) {
        if (node != null && Constants.isSchemaXSD(node.getNamespaceURI())) {
            String localName = node.getLocalName();
            return localName != null && localName.equals(schemaLocalName);
        }
        return false;
    }

    public static TypeEntry getComplexElementExtensionBase(Node node, SymbolTable symbolTable) {
        NodeList children;
        if (node == null) {
            return null;
        }
        Object cached = (TypeEntry)symbolTable.node2ExtensionBase.get(node);
        if (cached != null) {
            return cached;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            children = node.getChildNodes();
            Node complexNode = null;
            for (int j = 0; j < children.getLength() && complexNode == null; ++j) {
                if (!SchemaUtils.isXSDNode(children.item(j), "complexType")) continue;
                node = complexNode = children.item(j);
            }
        }
        if (SchemaUtils.isXSDNode(node, "complexType")) {
            QName extendsType;
            Node kid;
            int j;
            children = node.getChildNodes();
            Node content = null;
            Node extension = null;
            for (j = 0; j < children.getLength() && content == null; ++j) {
                kid = children.item(j);
                if (!SchemaUtils.isXSDNode(kid, "complexContent") && !SchemaUtils.isXSDNode(kid, "simpleContent")) continue;
                content = kid;
            }
            if (content != null) {
                children = content.getChildNodes();
                for (j = 0; j < children.getLength() && extension == null; ++j) {
                    kid = children.item(j);
                    if (!SchemaUtils.isXSDNode(kid, "extension")) continue;
                    extension = kid;
                }
            }
            cached = extension == null ? null : ((extendsType = Utils.getTypeQName(extension, new BooleanHolder(), false)) == null ? null : symbolTable.getType(extendsType));
        }
        symbolTable.node2ExtensionBase.put(node, cached);
        return cached;
    }

    public static QName getSimpleTypeBase(Node node) {
        NodeList children;
        QName baseQName = null;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (SchemaUtils.isXSDNode(node, "element")) {
            children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                if (!SchemaUtils.isXSDNode(children.item(j), "simpleType")) continue;
                node = children.item(j);
                break;
            }
        }
        if (SchemaUtils.isXSDNode(node, "simpleType")) {
            children = node.getChildNodes();
            Node restrictionNode = null;
            for (int j = 0; j < children.getLength() && restrictionNode == null; ++j) {
                if (!SchemaUtils.isXSDNode(children.item(j), "restriction")) continue;
                restrictionNode = children.item(j);
            }
            if (restrictionNode != null) {
                baseQName = Utils.getTypeQName(restrictionNode, new BooleanHolder(), false);
            }
            if (baseQName != null && restrictionNode != null) {
                NodeList enums = restrictionNode.getChildNodes();
                for (int i = 0; i < enums.getLength(); ++i) {
                    if (!SchemaUtils.isXSDNode(enums.item(i), "enumeration")) continue;
                    return null;
                }
            }
        }
        return baseQName;
    }

    public static Node getRestrictionOrExtensionNode(Node node) {
        int j;
        NodeList children;
        Node re = null;
        if (node == null) {
            return re;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            children = node.getChildNodes();
            Object node2 = null;
            for (j = 0; j < children.getLength(); ++j) {
                Node n = children.item(j);
                if (!SchemaUtils.isXSDNode(n, "simpleType") && !SchemaUtils.isXSDNode(n, "complexType") && !SchemaUtils.isXSDNode(n, "simpleContent")) continue;
                node = n;
                break;
            }
        }
        if (SchemaUtils.isXSDNode(node, "simpleType") || SchemaUtils.isXSDNode(node, "complexType")) {
            Node kid;
            children = node.getChildNodes();
            Node complexContent = null;
            if (node.getLocalName().equals("complexType")) {
                for (j = 0; j < children.getLength() && complexContent == null; ++j) {
                    kid = children.item(j);
                    if (!SchemaUtils.isXSDNode(kid, "complexContent") && !SchemaUtils.isXSDNode(kid, "simpleContent")) continue;
                    complexContent = kid;
                }
                node = complexContent;
            }
            if (node != null) {
                children = node.getChildNodes();
                for (j = 0; j < children.getLength() && re == null; ++j) {
                    kid = children.item(j);
                    if (!SchemaUtils.isXSDNode(kid, "extension") && !SchemaUtils.isXSDNode(kid, "restriction")) continue;
                    re = kid;
                }
            }
        }
        return re;
    }

    public static QName getArrayComponentQName(Node node, IntHolder dims) {
        dims.value = 1;
        QName qName = SchemaUtils.getCollectionComponentQName(node);
        if (qName == null) {
            qName = SchemaUtils.getArrayComponentQName_JAXRPC(node, dims);
        }
        return qName;
    }

    public static QName getCollectionComponentQName(Node node) {
        QName fullQName;
        BooleanHolder forElement;
        QName componentQName;
        if (node == null) {
            return null;
        }
        if (SchemaUtils.isXSDNode(node, "element") && (componentQName = Utils.getTypeQName(node, forElement = new BooleanHolder(), true)) != null && !componentQName.equals(fullQName = Utils.getTypeQName(node, forElement, false))) {
            return componentQName;
        }
        return null;
    }

    private static QName getArrayComponentQName_JAXRPC(Node node, IntHolder dims) {
        NodeList children;
        dims.value = 0;
        if (node == null) {
            return null;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node kid = children.item(j);
                if (!SchemaUtils.isXSDNode(kid, "complexType")) continue;
                node = kid;
                break;
            }
        }
        if (SchemaUtils.isXSDNode(node, "complexType")) {
            children = node.getChildNodes();
            Node complexContentNode = null;
            for (int j = 0; j < children.getLength(); ++j) {
                Node kid = children.item(j);
                if (!SchemaUtils.isXSDNode(kid, "complexContent") && !SchemaUtils.isXSDNode(kid, "simpleContent")) continue;
                complexContentNode = kid;
                break;
            }
            Node restrictionNode = null;
            if (complexContentNode != null) {
                children = complexContentNode.getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    Node kid = children.item(j);
                    if (!SchemaUtils.isXSDNode(kid, "restriction")) continue;
                    restrictionNode = kid;
                    break;
                }
            }
            QName baseType = null;
            if (!(restrictionNode == null || (baseType = Utils.getTypeQName(restrictionNode, new BooleanHolder(), false)) != null && baseType.getLocalPart().equals("Array") && Constants.isSOAP_ENC(baseType.getNamespaceURI()))) {
                baseType = null;
            }
            Node groupNode = null;
            Node attributeNode = null;
            if (baseType != null) {
                children = restrictionNode.getChildNodes();
                for (int j = 0; j < children.getLength() && groupNode == null && attributeNode == null; ++j) {
                    BooleanHolder isRef;
                    QName refQName;
                    Node kid = children.item(j);
                    if ((SchemaUtils.isXSDNode(kid, "sequence") || SchemaUtils.isXSDNode(kid, "all")) && (groupNode = kid).getChildNodes().getLength() == 0) {
                        groupNode = null;
                    }
                    if (!SchemaUtils.isXSDNode(kid, "attribute") || (refQName = Utils.getTypeQName(kid, isRef = new BooleanHolder(), false)) == null || !isRef.value || !refQName.getLocalPart().equals("arrayType") || !Constants.isSOAP_ENC(refQName.getNamespaceURI())) continue;
                    attributeNode = kid;
                }
            }
            if (attributeNode != null) {
                int i;
                String wsdlArrayTypeValue = null;
                Vector attrs = Utils.getAttributesWithLocalName(attributeNode, "arrayType");
                for (i = 0; i < attrs.size() && wsdlArrayTypeValue == null; ++i) {
                    Node attrNode = (Node)attrs.elementAt(i);
                    String attrName = attrNode.getNodeName();
                    QName attrQName = Utils.getQNameFromPrefixedName(attributeNode, attrName);
                    if (!Constants.isWSDL(attrQName.getNamespaceURI())) continue;
                    wsdlArrayTypeValue = attrNode.getNodeValue();
                }
                if (wsdlArrayTypeValue != null && (i = wsdlArrayTypeValue.indexOf(91)) > 0) {
                    String prefixedName = wsdlArrayTypeValue.substring(0, i);
                    String mangledString = wsdlArrayTypeValue.replace(',', '[');
                    dims.value = 0;
                    int index = mangledString.indexOf(91);
                    while (index > 0) {
                        ++dims.value;
                        index = mangledString.indexOf(91, index + 1);
                    }
                    return Utils.getQNameFromPrefixedName(restrictionNode, prefixedName);
                }
            } else if (groupNode != null) {
                String maxOccursValue;
                NodeList elements = groupNode.getChildNodes();
                Node elementNode = null;
                for (int i = 0; i < elements.getLength() && elementNode == null; ++i) {
                    Node kid = elements.item(i);
                    if (!SchemaUtils.isXSDNode(kid, "element")) continue;
                    elementNode = elements.item(i);
                    break;
                }
                if (elementNode != null && (maxOccursValue = Utils.getAttribute(elementNode, "maxOccurs")) != null && maxOccursValue.equalsIgnoreCase("unbounded")) {
                    dims.value = 1;
                    return Utils.getTypeQName(elementNode, new BooleanHolder(), true);
                }
            }
        }
        return null;
    }

    public static Vector getContainedAttributeTypes(Node node, SymbolTable symbolTable) {
        NodeList children;
        Vector<Serializable> v = null;
        if (node == null) {
            return null;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node kid = children.item(j);
                if (!SchemaUtils.isXSDNode(kid, "complexType")) continue;
                node = kid;
                break;
            }
        }
        if (SchemaUtils.isXSDNode(node, "complexType")) {
            Node kid;
            int j;
            children = node.getChildNodes();
            Node content = null;
            for (j = 0; j < children.getLength(); ++j) {
                kid = children.item(j);
                if (!SchemaUtils.isXSDNode(kid, "complexContent") && !SchemaUtils.isXSDNode(kid, "simpleContent")) continue;
                content = kid;
                break;
            }
            if (content != null) {
                children = content.getChildNodes();
                for (j = 0; j < children.getLength(); ++j) {
                    kid = children.item(j);
                    if (!SchemaUtils.isXSDNode(kid, "extension")) continue;
                    node = kid;
                    break;
                }
            }
            children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!SchemaUtils.isXSDNode(child, "attribute")) continue;
                if (v == null) {
                    v = new Vector<Serializable>();
                }
                QName attributeName = Utils.getNodeNameQName(child);
                BooleanHolder forElement = new BooleanHolder();
                QName attributeType = Utils.getTypeQName(child, forElement, false);
                if (!forElement.value) {
                    String def;
                    String form = Utils.getAttribute(child, "form");
                    if (form != null && form.equals("unqualified")) {
                        attributeName = Utils.findQName("", attributeName.getLocalPart());
                    } else if (form == null && ((def = Utils.getScopedAttribute(child, "attributeFormDefault")) == null || def.equals("unqualified"))) {
                        attributeName = Utils.findQName("", attributeName.getLocalPart());
                    }
                } else {
                    attributeName = attributeType;
                }
                TypeEntry type = symbolTable.getTypeEntry(attributeType, forElement.value);
                if (type == null || attributeName == null) continue;
                v.add(type);
                v.add(attributeName);
            }
        }
        return v;
    }

    private static boolean isSimpleSchemaType(String s) {
        if (s == null) {
            return false;
        }
        return schemaTypeSet.contains(s);
    }

    public static boolean isSimpleSchemaType(QName qname) {
        if (qname == null || !Constants.isSchemaXSD(qname.getNamespaceURI())) {
            return false;
        }
        return SchemaUtils.isSimpleSchemaType(qname.getLocalPart());
    }
}

