/**
 * GlobalLBPoolV2PortType.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Jan 23, 2013 (02:07:54 PST) WSDL2Java emitter.
 */

package iControl;

public interface GlobalLBPoolV2PortType extends java.rmi.Remote {

    /**
     * Adds terminal members to the specified pools. Terminal members
     * are
     *  virtual servers that have been added as members of an address type
     * pool, A or AAAA. Terminal members representing IPv4 addresses can
     *  only be added to pools of type A and terminal members representing
     * IPv6 addresses can only be added to pools of type AAAA.
     * 
     *  All members, both terminal and non-terminal, are reordered starting
     * with 0, with no gaps, so the system maintains the relative order but
     * not the absolute numbers originally specified for ordering.
     */
    public void add_member(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBVirtualServerID[][] members, long[][] orders) throws java.rmi.RemoteException;

    /**
     * Adds virtual server dependencies to the specified terminal
     * members
     *  of the specified pools.
     * 
     *  If you add virtual servers as a dependency on a pool member, that
     * pool member is only considered to be available if all of the
     *  member's virtual server dependencies are also available.
     */
    public void add_member_dependency(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBVirtualServerID[][] members, iControl.GlobalLBVirtualServerID[][][] dependencies) throws java.rmi.RemoteException;

    /**
     * Adds the metadata for the specified pools.
     * 
     *  User metadata, also metadata for short, is mainly a name/value
     *  pair that is associated with a metadata capable config (MCC) object.
     * Some examples of MCC objects are ltm pool and virtual server.
     *  The combination of the MCC object name and the metadata name
     *  uniquely identify an instance of the metadata. One MCC object
     *  may have multiple instances of metadata associated with it.
     *  In addition to name/value pair, metadata also has a persistence
     *  attribute. See Common::MetadataPersistence for more information.
     */
    public void add_metadata(iControl.GlobalLBPoolID[] pools, java.lang.String[][] names, java.lang.String[][] values) throws java.rmi.RemoteException;

    /**
     * Adds CNAME type non-terminal members with their specified orders
     * and
     *  static-target states. The parent pools must be of type CNAME.
     * 
     *  In the PoolV2 interface members can now also be non-terminal type
     * members
     *  (no longer only virtual servers). Non-terminal members are specified
     * with
     *  a required dname. The dname of the non-terminal member is non-folderized
     * and must be a fully-qualified domain name. The dname of the non-terminal
     * member must match (exactly or via wide IP wildcard match) the name
     * of a
     *  corresponding wide IP of the correct type (without the folder name).
     * Note
     *  that in the special case where static-target is enabled on a CNAME
     * member,
     *  this member is not backed by a wide IP.
     * 
     *  The dname of CNAME type non-terminal members (with static-target
     * disabled)
     *  must match the name of an existing A, AAAA, CNAME, MX, SRV, or NAPTR
     * type
     *  wide IP.
     * 
     *  The members are reordered starting with 0, with no gaps, so the
     *  system maintains the relative order but not the absolute numbers
     *  originally specified for ordering.
     * 
     *  If static-target is enabled it means the non-terminal member is not
     * backed
     *  by a wide IP and instead when the member is picked it simply returns
     * the
     *  dname of the member as a static answer. Note: the default static-target
     * setting is disabled.
     */
    public void add_non_terminal_member_cname(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members, long[][] orders, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Adds MX type non-terminal members with their specified orders.
     * The parent
     *  pools must be of type MX.
     * 
     *  In the PoolV2 interface members can now also be non-terminal type
     * members
     *  (no longer only virtual servers). Non-terminal members are specified
     * with
     *  a required dname. The dname of the non-terminal member is non-folderized
     * and must be a fully-qualified domain name. The dname of the non-terminal
     * member must match (exactly or via wide IP wildcard match) the name
     * of a
     *  corresponding wide IP of the correct type (without the folder name).
     * 
     *  The dname of MX type non-terminal members must match the name of
     * an
     *  existing A or AAAA type wide IP.
     * 
     *  The members are reordered starting with 0, with no gaps, so the
     *  system maintains the relative order but not the absolute numbers
     *  originally specified for ordering.
     */
    public void add_non_terminal_member_mx(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members, long[][] orders) throws java.rmi.RemoteException;

    /**
     * Adds NAPTR type non-terminal members with their specified orders,
     * RDATA flags, and RDATA services. The parent pools must be of type
     * NAPTR.
     * 
     *  In the PoolV2 interface members can now also be non-terminal type
     * members
     *  (no longer only virtual servers). Non-terminal members are specified
     * with
     *  a required dname. The dname of the non-terminal member is non-folderized
     * and must be a fully-qualified domain name. The dname of the non-terminal
     * member must match (exactly or via wide IP wildcard match) the name
     * of a
     *  corresponding wide IP of the correct type (without the folder name).
     * 
     *  The dname of NAPTR type non-terminal members using the 's' flag must
     * match the name of an existing SRV type wide IP. The dname of NAPTR
     * type non-terminal members using the 'a' flag must match the name of
     * an existing A or AAAA type wide IP.
     * 
     *  The members are reordered starting with 0, with no gaps, so the
     *  system maintains the relative order but not the absolute numbers
     *  originally specified for ordering.
     * 
     *  The RDATA flags field must be specified and valid input is either
     * 'a' for address type or 's' for service type. The RDATA service
     *  field must be specified.
     * 
     *  RDATA is a field in a DNS resource record (RR). The contents of the
     * RDATA field
     *  depend on the type of RR. For example an A type RR would contain
     * an IPv4 address
     *  in the RDATA section while a CNAME type RR would contain the string
     * name of an
     *  alias domain name.
     */
    public void add_non_terminal_member_naptr(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members, long[][] orders, java.lang.String[][] flags, java.lang.String[][] services) throws java.rmi.RemoteException;

    /**
     * Adds SRV type non-terminal members with their specified orders,
     * and RDATA ports. The parent pools must be of type SRV.
     * 
     *  In the PoolV2 interface members can now also be non-terminal type
     * members
     *  (no longer only virtual servers). Non-terminal members are specified
     * with
     *  a required dname. The dname of the non-terminal member is non-folderized
     * and must be a fully-qualified domain name. The dname of the non-terminal
     * member must match (exactly or via wide IP wildcard match) the name
     * of a
     *  corresponding wide IP of the correct type (without the folder name).
     * 
     *  The dname of SRV type non-terminal members must match the name of
     * an
     *  existing A or AAAA type wide IP.
     * 
     *  The members are reordered starting with 0, with no gaps, so the
     *  system maintains the relative order but not the absolute numbers
     *  originally specified for ordering.
     * 
     *  The RDATA port must be specified.
     * 
     *  RDATA is a field in a DNS resource record (RR). The contents of the
     * RDATA field
     *  depend on the type of RR. For example an A type RR would contain
     * an IPv4 address
     *  in the RDATA section while a CNAME type RR would contain the string
     * name of an
     *  alias domain name.
     */
    public void add_non_terminal_member_srv(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members, long[][] orders, long[][] ports) throws java.rmi.RemoteException;

    /**
     * Creates the specified pools.
     */
    public void create(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBLBMethod[] lb_methods) throws java.rmi.RemoteException;

    /**
     * Deletes all pools.
     */
    public void delete_all_pools() throws java.rmi.RemoteException;

    /**
     * Deletes the specified pools.
     */
    public void delete_pool(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the statistics for all the pools.
     */
    public iControl.GlobalLBPoolV2PoolStatistics get_all_statistics() throws java.rmi.RemoteException;

    /**
     * Gets the alternate load balancing methods for the specified
     * pools.
     */
    public iControl.GlobalLBLBMethod[] get_alternate_lb_method(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the descriptions for a set of pools.
     */
    public java.lang.String[] get_description(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the states to indicate whether to use dynamic ratio to
     * modify
     *  the behavior of QOS.
     */
    public iControl.CommonEnabledState[] get_dynamic_ratio_state(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the enabled state of the specified pools.
     */
    public iControl.CommonEnabledState[] get_enabled_state(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the fallback/emergency failure address for the specified
     * pools.
     */
    public java.lang.String[] get_fallback_ip(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the fallback load balancing methods for the specified
     * pools.
     */
    public iControl.GlobalLBLBMethod[] get_fallback_lb_method(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets all metrics limits for a sequence of pools.
     */
    public iControl.GlobalLBMetricLimit[][] get_limit(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets a list of all pools.
     */
    public iControl.GlobalLBPoolID[] get_list() throws java.rmi.RemoteException;

    /**
     * Gets a list of pools of the specified GTM query types.
     */
    public iControl.GlobalLBPoolID[][] get_list_by_type(iControl.GlobalLBGTMQueryType[] types) throws java.rmi.RemoteException;

    /**
     * Gets the states indicating whether to disable pool members
     * when their
     *  pool member status goes from Green to Red.
     */
    public iControl.CommonEnabledState[] get_manual_resume_state(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the terminal members of a set of pools.
     */
    public iControl.GlobalLBVirtualServerID[][] get_member(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the virtual server dependencies from the specified terminal
     * members of the specified pools.
     */
    public iControl.GlobalLBVirtualServerID[][][] get_member_dependency(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBVirtualServerID[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the description of a set of terminal pool members in a
     * set of pools.
     */
    public java.lang.String[][] get_member_description(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBVirtualServerID[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the enabled states for the specified terminal members
     *  of the specified pools.
     */
    public iControl.CommonEnabledState[][] get_member_enabled_state(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBVirtualServerID[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the metric limits for the specified terminal members of
     * the specified
     *  pools.
     */
    public iControl.GlobalLBMetricLimit[][][] get_member_limit(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBVirtualServerID[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the monitor rules for the specified terminal members of
     * the specified
     *  pools.
     */
    public iControl.GlobalLBMonitorRule[][] get_member_monitor_rule(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBVirtualServerID[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the statuses for the specified terminal members of the
     * specified pools.
     */
    public iControl.CommonObjectStatus[][] get_member_object_status(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBVirtualServerID[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the orders for the specified terminal members of the specified
     * pools.
     */
    public long[][] get_member_order(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBVirtualServerID[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the ratios for the specified terminal members of the
     *  specified pools. This is used in weighting pool members
     *  for load balancing decisions.
     */
    public long[][] get_member_ratio(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBVirtualServerID[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the statistics for the specified terminal members of the
     * specified
     *  pools.
     */
    public iControl.GlobalLBPoolV2MemberStatistics get_member_statistics(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBVirtualServerID[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the user metadata for the specified pools.
     */
    public java.lang.String[][] get_metadata(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the metadata descriptions for the specified metadata.
     */
    public java.lang.String[][] get_metadata_description(iControl.GlobalLBPoolID[] pools, java.lang.String[][] names) throws java.rmi.RemoteException;

    /**
     * Gets the persistence for the specified metadata.
     */
    public iControl.CommonMetadataPersistence[][] get_metadata_persistence(iControl.GlobalLBPoolID[] pools, java.lang.String[][] names) throws java.rmi.RemoteException;

    /**
     * Gets the metadata values for the specified metadata.
     */
    public java.lang.String[][] get_metadata_value(iControl.GlobalLBPoolID[] pools, java.lang.String[][] names) throws java.rmi.RemoteException;

    /**
     * Gets the monitor rules for the specified pools.
     */
    public iControl.GlobalLBMonitorRule[] get_monitor_rule(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the non-terminal members of a set of pools.
     */
    public java.lang.String[][] get_non_terminal_member(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the description of a set of non-terminal pool members
     * in a set of pools.
     */
    public java.lang.String[][] get_non_terminal_member_description(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the enabled states for the specified non-terminal members
     * of the specified pools.
     */
    public iControl.CommonEnabledState[][] get_non_terminal_member_enabled_state(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the statuses for the specified non-terminal members of
     * the specified pools.
     */
    public iControl.CommonObjectStatus[][] get_non_terminal_member_object_status(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the orders for the specified non-terminal members of the
     * specified pools.
     */
    public long[][] get_non_terminal_member_order(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the ratios for the specified non-terminal members of the
     * specified pools.
     */
    public long[][] get_non_terminal_member_ratio(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the RDATA flags of a set of non-terminal pool members
     * in a set of pools.
     */
    public java.lang.String[][] get_non_terminal_member_rdata_flags(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the RDATA order of a set of non-terminal pool members
     * in a set of pools.
     */
    public long[][] get_non_terminal_member_rdata_order(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the RDATA port of a set of non-terminal pool members in
     * a set of pools.
     */
    public long[][] get_non_terminal_member_rdata_port(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the RDATA preference of a set of non-terminal pool members
     * in a set of pools.
     */
    public long[][] get_non_terminal_member_rdata_preference(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the RDATA priority of a set of non-terminal pool members
     * in a set of pools.
     */
    public long[][] get_non_terminal_member_rdata_priority(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the RDATA service of a set of non-terminal pool members
     * in a set of pools.
     */
    public java.lang.String[][] get_non_terminal_member_rdata_service(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the RDATA weight of a set of non-terminal pool members
     * in a set of pools.
     */
    public long[][] get_non_terminal_member_rdata_weight(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the static target state of a set of non-terminal pool
     * members in a set of pools.
     */
    public iControl.CommonEnabledState[][] get_non_terminal_member_static_target_state(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the statistics for the specified non-terminal members
     *  of the specified pools.
     */
    public iControl.GlobalLBPoolV2MemberStatistics get_non_terminal_member_statistics(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members) throws java.rmi.RemoteException;

    /**
     * Gets the availability statuses of the specified pools.
     */
    public iControl.CommonObjectStatus[] get_object_status(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the preferred load balancing methods for the specified
     * pools.
     */
    public iControl.GlobalLBLBMethod[] get_preferred_lb_method(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the relative weight for ping packet completion rate when
     * the load balancing mode is set to LB_METHOD_QOS.
     */
    public long[] get_qos_coefficient_hit_ratio(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the relative weight for hops when the load balancing mode
     * is set to LB_METHOD_QOS.
     */
    public long[] get_qos_coefficient_hops(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the relative weight for kilobytes per second when the
     * load balancing mode is set to LB_METHOD_QOS.
     */
    public long[] get_qos_coefficient_kbps(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the relative weight for link capacity when the load balancing
     * mode is set to LB_METHOD_QOS.
     */
    public long[] get_qos_coefficient_link_capacity(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the relative weight for packet rate when the load balancing
     * mode is set to LB_METHOD_QOS.
     */
    public long[] get_qos_coefficient_packet_rate(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the relative weight for round-trip time when the load
     * balancing mode is set to LB_METHOD_QOS.
     */
    public long[] get_qos_coefficient_rtt(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the relative weight for topology when the load balancing
     * mode is set to LB_METHOD_QOS.
     */
    public long[] get_qos_coefficient_topology(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the relative weight for virtual server capacity when the
     * load balancing mode is set to LB_METHOD_QOS.
     */
    public long[] get_qos_coefficient_vs_capacity(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the relative weight for virtual server (VS) score when
     * the load balancing mode is set to LB_METHOD_QOS.
     */
    public long[] get_qos_coefficient_vs_score(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the number of answers to return for the specified pools.
     */
    public long[] get_returned_answers_count(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the statistics for the specified pools.
     */
    public iControl.GlobalLBPoolV2PoolStatistics get_statistics(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the TTL values for the specified pools.
     */
    public long[] get_ttl(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the states to indicate whether to check the availability
     * of a pool
     *  member before using it.
     */
    public iControl.CommonEnabledState[] get_verify_member_availability_state(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Gets the version information for this interface.
     */
    public java.lang.String get_version() throws java.rmi.RemoteException;

    /**
     * Removes all virtual server dependencies from the specified
     * terminal
     *  members of the specified pools.
     */
    public void remove_all_member_dependencies(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBVirtualServerID[][] members) throws java.rmi.RemoteException;

    /**
     * Removes all members, both terminal and non-terminal, from the
     * specified pools.
     */
    public void remove_all_members(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Removes all the metadata instances for the specified pools.
     */
    public void remove_all_metadata(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Removes terminal members from the specified pools.
     */
    public void remove_member(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBVirtualServerID[][] members) throws java.rmi.RemoteException;

    /**
     * Removes virtual server dependencies from the specified terminal
     * members of the specified pools.
     */
    public void remove_member_dependency(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBVirtualServerID[][] members, iControl.GlobalLBVirtualServerID[][][] dependencies) throws java.rmi.RemoteException;

    /**
     * Removes the metadata for the specified pools and names.
     */
    public void remove_metadata(iControl.GlobalLBPoolID[] pools, java.lang.String[][] names) throws java.rmi.RemoteException;

    /**
     * Removes the monitor rules for the specified pools.  The specified
     * pools will no longer be monitored.
     */
    public void remove_monitor_rule(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Removes non-terminal members from the specified pools.
     */
    public void remove_non_terminal_member(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members) throws java.rmi.RemoteException;

    /**
     * Resets the statistics for the specified terminal members
     *  of the specified pools.
     */
    public void reset_member_statistics(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBVirtualServerID[][] members) throws java.rmi.RemoteException;

    /**
     * Resets the statistics for the specified non-terminal members
     * of the specified pools.
     */
    public void reset_non_terminal_member_statistics(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members) throws java.rmi.RemoteException;

    /**
     * Resets the statistics for the specified pools.
     */
    public void reset_statistics(iControl.GlobalLBPoolID[] pools) throws java.rmi.RemoteException;

    /**
     * Sets the alternate load balancing methods for the specified
     * pools.
     */
    public void set_alternate_lb_method(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBLBMethod[] lb_methods) throws java.rmi.RemoteException;

    /**
     * Sets the description for a set of pools.
     * 
     *  This is an arbitrary field which can be used for any purpose.
     */
    public void set_description(iControl.GlobalLBPoolID[] pools, java.lang.String[] descriptions) throws java.rmi.RemoteException;

    /**
     * Sets the states to indicate whether to use dynamic ratio to
     * modify
     *  the behavior of QOS.
     * 
     *  This option is disabled by default, and in that case the system uses
     * only the server or virtual server with the best metrics, or highest
     * quality of service (QoS) score, for load balancing. When dynamic ratio
     * is enabled, the system treats QoS scores as ratios, and it uses each
     * server or virtual server in proportion to the ratio determined by
     * the
     *  QoS calculation.
     * 
     *  This option only applies when you are also using one of the following
     * load balancing method on the given pool: LB_METHOD_HIT_RATIO,
     *  LB_METHOD_LOWEST_HOPS, LB_METHOD_BPS, LB_METHOD_LEAST_CONN,
     *  LB_METHOD_LOWEST_RTT, LB_METHOD_QOS, LB_METHOD_VS_CAPACITY, or
     *  LB_METHOD_VS_SCORE.
     */
    public void set_dynamic_ratio_state(iControl.GlobalLBPoolID[] pools, iControl.CommonEnabledState[] states) throws java.rmi.RemoteException;

    /**
     * Sets the enabled state of the specified pools.
     */
    public void set_enabled_state(iControl.GlobalLBPoolID[] pools, iControl.CommonEnabledState[] states) throws java.rmi.RemoteException;

    /**
     * Sets the fallback/emergency failure address for the specified
     * pools.
     * 
     *  Note that this is only allowed and relevant to type A and AAAA pools.
     * In such a case, you may only specify a sinlge address that matches
     * the respective pool type, namely IPv4 for A and IPv6 for AAAA.
     */
    public void set_fallback_ip(iControl.GlobalLBPoolID[] pools, java.lang.String[] ips) throws java.rmi.RemoteException;

    /**
     * Sets the fallback load balancing methods for the specified
     * pools.
     * 
     *  Note that the fallback IP load balancing method is only allowed and
     * relevant to type A and AAAA pools. In that case there will only
     *  be a single address specified matching the respective pool type.
     */
    public void set_fallback_lb_method(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBLBMethod[] lb_methods) throws java.rmi.RemoteException;

    /**
     * Sets the metric limits for a list of pools.
     * 
     *  The metric limits let users configure the allowed metric maximums
     * for virtual
     *  servers that back terminal pool members on the given pool. If the
     * allowed maximum
     *  for a given (enabled) limit is exceeded for a pool member, that pool
     * member
     *  becomes unavailable until the virtual server backing it reports metrics
     * that are
     *  less than the allowed maximums.
     * 
     *  Three types of limits can be set. These are the data throughput rate
     * (in bits
     *  per second), the number of current connections, and the data transfer
     * rate (in
     *  packets per second). The metric limits also allow the user to toggle
     * the
     *  enforcement of these numerical limits between enabled and disabled.
     * By default
     *  all three types of limits are disabled.
     */
    public void set_limit(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBMetricLimit[][] limits) throws java.rmi.RemoteException;

    /**
     * Sets the states indicating whether to disable pool members
     * when their
     *  pool member status goes from Green to Red.
     */
    public void set_manual_resume_state(iControl.GlobalLBPoolID[] pools, iControl.CommonEnabledState[] states) throws java.rmi.RemoteException;

    /**
     * Sets the description of a set of pool terminal members in a
     * set of pools.
     * 
     *  This is an arbitrary field which can be used for any purpose.
     */
    public void set_member_description(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBVirtualServerID[][] members, java.lang.String[][] descriptions) throws java.rmi.RemoteException;

    /**
     * Sets the enabled states for the specified terminal members
     *  of the specified pools.
     */
    public void set_member_enabled_state(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBVirtualServerID[][] members, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the metric limits for the specified terminal members of
     * the specified
     *  pools.
     * 
     *  The metric limits let users configure the allowed metric maximums
     * for virtual
     *  servers that back the given terminal pool members. If the allowed
     * maximum for
     *  a given (enabled) limit is exceeded for a pool member, that pool
     * member becomes
     *  unavailable until the virtual server backing it reports metrics that
     * are less
     *  than the allowed maximums.
     * 
     *  Three types of limits can be set. These are the data throughput rate
     * (in bits
     *  per second), the number of current connections, and the data transfer
     * rate (in
     *  packets per second). The metric limits also allow the user to toggle
     * the
     *  enforcement of these numerical limits between enabled and disabled.
     * By default
     *  all three types of limits are disabled.
     */
    public void set_member_limit(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBVirtualServerID[][] members, iControl.GlobalLBMetricLimit[][][] limits) throws java.rmi.RemoteException;

    /**
     * Sets the monitor rules for the specified terminal members of
     * the specified
     *  pools.
     */
    public void set_member_monitor_rule(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBVirtualServerID[][] members, iControl.GlobalLBMonitorRule[][] rules) throws java.rmi.RemoteException;

    /**
     * Sets the orders for the specified terminal members of the specified
     * pools.
     * 
     *  The members are reordered starting with 0, with no gaps, so the
     *  system maintains the relative order but not the absolute numbers
     *  originally specified for ordering.
     */
    public void set_member_order(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBVirtualServerID[][] members, long[][] orders) throws java.rmi.RemoteException;

    /**
     * Sets the ratios for the specified terminal members of the
     *  specified pools. This is used in weighting pool members
     *  for load balancing decisions.
     */
    public void set_member_ratio(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBVirtualServerID[][] members, long[][] ratios) throws java.rmi.RemoteException;

    /**
     * Sets the descriptions for the specified metadata.
     * 
     *  This is an arbitrary field which can be used for any purpose.
     */
    public void set_metadata_description(iControl.GlobalLBPoolID[] pools, java.lang.String[][] names, java.lang.String[][] descriptions) throws java.rmi.RemoteException;

    /**
     * Sets the persistence for the specified metadata.
     */
    public void set_metadata_persistence(iControl.GlobalLBPoolID[] pools, java.lang.String[][] names, iControl.CommonMetadataPersistence[][] values) throws java.rmi.RemoteException;

    /**
     * Sets the values for the specified metadata.
     */
    public void set_metadata_value(iControl.GlobalLBPoolID[] pools, java.lang.String[][] names, java.lang.String[][] values) throws java.rmi.RemoteException;

    /**
     * Sets/creates the monitor rules for the specified pools. The
     * 'none'
     *  monitor is no longer a valid monitor_template for a MonitorRule.
     *  Any monitor rules created using the keyword 'none' will be adjusted
     * and the 'none' monitor removed.
     */
    public void set_monitor_rule(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBMonitorRule[] rules) throws java.rmi.RemoteException;

    /**
     * Sets the description of a set of non-terminal pool members
     * in a set of pools.
     * 
     *  This is an arbitrary field which can be used for any purpose.
     */
    public void set_non_terminal_member_description(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members, java.lang.String[][] descriptions) throws java.rmi.RemoteException;

    /**
     * Sets the enabled states for the specified non-terminal
     *  members of the specified pools.
     */
    public void set_non_terminal_member_enabled_state(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the orders for the specified non-terminal members of the
     * specified pools.
     * 
     *  The members are reordered starting with 0, with no gaps, so the
     *  system maintains the relative order but not the absolute numbers
     *  originally specified for ordering.
     */
    public void set_non_terminal_member_order(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members, long[][] orders) throws java.rmi.RemoteException;

    /**
     * Sets the ratios for the specified non-terminal members of the
     * specified pools.
     */
    public void set_non_terminal_member_ratio(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members, long[][] ratios) throws java.rmi.RemoteException;

    /**
     * Sets the RDATA flags of a set of non-terminal pool members
     * in a set of pools.
     *  Note this is only valid for NAPTR type pool members. There is no
     * default value.
     *  If specified, valid input is either 'a' for address type or 's' for
     * service type.
     * 
     *  The dname of NAPTR type non-terminal members using the 's' flag must
     * match the name of an existing SRV type wide IP. The dname of NAPTR
     * type non-terminal members using the 'a' flag must match the name of
     * an existing A or AAAA type wide IP.
     * 
     *  RDATA is a field in a DNS resource record (RR). The contents of the
     * RDATA field
     *  depend on the type of RR. For example an A type RR would contain
     * an IPv4 address
     *  in the RDATA section while a CNAME type RR would contain the string
     * name of an
     *  alias domain name.
     */
    public void set_non_terminal_member_rdata_flags(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members, java.lang.String[][] flags) throws java.rmi.RemoteException;

    /**
     * Sets the RDATA order of a set of non-terminal pool members
     * in a set of pools.
     *  Note this is only valid for NAPTR type pool members. The default
     * is 10.
     * 
     *  RDATA is a field in a DNS resource record (RR). The contents of the
     * RDATA field
     *  depend on the type of RR. For example an A type RR would contain
     * an IPv4 address
     *  in the RDATA section while a CNAME type RR would contain the string
     * name of an
     *  alias domain name.
     */
    public void set_non_terminal_member_rdata_order(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members, long[][] orders) throws java.rmi.RemoteException;

    /**
     * Sets the RDATA port of a set of non-terminal pool members in
     * a set of pools.
     *  Note this is only valid for SRV type pool members. There is no default
     * value.
     * 
     *  RDATA is a field in a DNS resource record (RR). The contents of the
     * RDATA field
     *  depend on the type of RR. For example an A type RR would contain
     * an IPv4 address
     *  in the RDATA section while a CNAME type RR would contain the string
     * name of an
     *  alias domain name.
     */
    public void set_non_terminal_member_rdata_port(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members, long[][] ports) throws java.rmi.RemoteException;

    /**
     * Sets the RDATA preference of a set of non-terminal pool members
     * in a set of pools.
     *  Note this is only valid for NAPTR type pool members. The default
     * is 10.
     * 
     *  RDATA is a field in a DNS resource record (RR). The contents of the
     * RDATA field
     *  depend on the type of RR. For example an A type RR would contain
     * an IPv4 address
     *  in the RDATA section while a CNAME type RR would contain the string
     * name of an
     *  alias domain name.
     */
    public void set_non_terminal_member_rdata_preference(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members, long[][] preferences) throws java.rmi.RemoteException;

    /**
     * Sets the RDATA priority of a set of non-terminal pool members
     * in a set of pools.
     *  Note this is only valid for MX or SRV type pool members. The default
     * is 10.
     * 
     *  RDATA is a field in a DNS resource record (RR). The contents of the
     * RDATA field
     *  depend on the type of RR. For example an A type RR would contain
     * an IPv4 address
     *  in the RDATA section while a CNAME type RR would contain the string
     * name of an
     *  alias domain name.
     */
    public void set_non_terminal_member_rdata_priority(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members, long[][] priorities) throws java.rmi.RemoteException;

    /**
     * Sets the RDATA service of a set of non-terminal pool members
     * in a set of pools.
     *  Note this is only valid for NAPTR type pool members. There is no
     * default value.
     * 
     *  RDATA is a field in a DNS resource record (RR). The contents of the
     * RDATA field
     *  depend on the type of RR. For example an A type RR would contain
     * an IPv4 address
     *  in the RDATA section while a CNAME type RR would contain the string
     * name of an
     *  alias domain name.
     */
    public void set_non_terminal_member_rdata_service(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members, java.lang.String[][] services) throws java.rmi.RemoteException;

    /**
     * Sets the RDATA weight of a set of non-terminal pool members
     * in a set of pools.
     *  Note this is only valid for SRV type pool members. The default is
     * 10.
     * 
     *  RDATA is a field in a DNS resource record (RR). The contents of the
     * RDATA field
     *  depend on the type of RR. For example an A type RR would contain
     * an IPv4 address
     *  in the RDATA section while a CNAME type RR would contain the string
     * name of an
     *  alias domain name.
     */
    public void set_non_terminal_member_rdata_weight(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members, long[][] weights) throws java.rmi.RemoteException;

    /**
     * Sets the static target state of a set of non-terminal pool
     * members in a set of pools.
     *  Note this is only valid for CNAME type pool members. The default
     * is disabled (false).
     * 
     *  The dname of CNAME type non-terminal members (with static-target
     * disabled)
     *  must match the name of an existing A, AAAA, CNAME, MX, SRV, or NAPTR
     * type
     *  wide IP.
     */
    public void set_non_terminal_member_static_target_state(iControl.GlobalLBPoolID[] pools, java.lang.String[][] members, iControl.CommonEnabledState[][] states) throws java.rmi.RemoteException;

    /**
     * Sets the preferred load balancing methods for the specified
     * pools.
     */
    public void set_preferred_lb_method(iControl.GlobalLBPoolID[] pools, iControl.GlobalLBLBMethod[] lb_methods) throws java.rmi.RemoteException;

    /**
     * Sets the relative weight for ping packet completion rate when
     * the load balancing
     *  mode is set to LB_METHOD_QOS. The default is 5.
     * 
     *  These weights help determine the importance of a given QoS (Quality
     * of Service)
     *  metric in calculating a score that is used to pick pool members.
     * For example,
     *  if you increase the RTT QoS coefficient on a given pool, the rtt
     * performance
     *  metric will have a larger effect on the overall scores of the pool's
     * pool
     *  members (ie pool members with better/lower rtts will now be more
     * likely to
     *  be picked).
     */
    public void set_qos_coefficient_hit_ratio(iControl.GlobalLBPoolID[] pools, long[] values) throws java.rmi.RemoteException;

    /**
     * Sets the relative weight for hops when the load balancing mode
     * is set
     *  to LB_METHOD_QOS. The default is 0.
     * 
     *  These weights help determine the importance of a given QoS (Quality
     * of Service)
     *  metric in calculating a score that is used to pick pool members.
     * For example,
     *  if you increase the RTT QoS coefficient on a given pool, the rtt
     * performance
     *  metric will have a larger effect on the overall scores of the pool's
     * pool
     *  members (ie pool members with better/lower rtts will now be more
     * likely to
     *  be picked).
     */
    public void set_qos_coefficient_hops(iControl.GlobalLBPoolID[] pools, long[] values) throws java.rmi.RemoteException;

    /**
     * Sets the relative weight for virtual server performance metric
     * kilobytes per
     *  second when the load balancing mode is set to LB_METHOD_QOS. The
     * default is 3.
     * 
     *  These weights help determine the importance of a given QoS (Quality
     * of Service)
     *  metric in calculating a score that is used to pick pool members.
     * For example,
     *  if you increase the RTT QoS coefficient on a given pool, the rtt
     * performance
     *  metric will have a larger effect on the overall scores of the pool's
     * pool
     *  members (ie pool members with better/lower rtts will now be more
     * likely to
     *  be picked).
     */
    public void set_qos_coefficient_kbps(iControl.GlobalLBPoolID[] pools, long[] values) throws java.rmi.RemoteException;

    /**
     * Sets the relative weight for link capacity when the load balancing
     * mode
     *  is set to LB_METHOD_QOS. The default is 30.
     * 
     *  These weights help determine the importance of a given QoS (Quality
     * of Service)
     *  metric in calculating a score that is used to pick pool members.
     * For example,
     *  if you increase the RTT QoS coefficient on a given pool, the rtt
     * performance
     *  metric will have a larger effect on the overall scores of the pool's
     * pool
     *  members (ie pool members with better/lower rtts will now be more
     * likely to
     *  be picked).
     */
    public void set_qos_coefficient_link_capacity(iControl.GlobalLBPoolID[] pools, long[] values) throws java.rmi.RemoteException;

    /**
     * Sets the relative weight for packet rate when the load balancing
     * mode is set
     *  to LB_METHOD_QOS. The default is 1.
     * 
     *  These weights help determine the importance of a given QoS (Quality
     * of Service)
     *  metric in calculating a score that is used to pick pool members.
     * For example,
     *  if you increase the RTT QoS coefficient on a given pool, the rtt
     * performance
     *  metric will have a larger effect on the overall scores of the pool's
     * pool
     *  members (ie pool members with better/lower rtts will now be more
     * likely to
     *  be picked).
     */
    public void set_qos_coefficient_packet_rate(iControl.GlobalLBPoolID[] pools, long[] values) throws java.rmi.RemoteException;

    /**
     * Sets the relative weight for round-trip time performance factor
     * when the
     *  load balancing mode is set to LB_METHOD_QOS. The default is 50.
     * 
     *  These weights help determine the importance of a given QoS (Quality
     * of Service)
     *  metric in calculating a score that is used to pick pool members.
     * For example,
     *  if you increase the RTT QoS coefficient on a given pool, the rtt
     * performance
     *  metric will have a larger effect on the overall scores of the pool's
     * pool
     *  members (i.e. pool members with better/lower rtts will now be more
     * likely to
     *  be picked).
     */
    public void set_qos_coefficient_rtt(iControl.GlobalLBPoolID[] pools, long[] values) throws java.rmi.RemoteException;

    /**
     * Sets the relative weight for topology when the load balancing
     * mode is set
     *  to LB_METHOD_QOS. The default is 0.
     * 
     *  These weights help determine the importance of a given QoS (Quality
     * of Service)
     *  metric in calculating a score that is used to pick pool members.
     * For example,
     *  if you increase the RTT QoS coefficient on a given pool, the rtt
     * performance
     *  metric will have a larger effect on the overall scores of the pool's
     * pool
     *  members (ie pool members with better/lower rtts will now be more
     * likely to
     *  be picked).
     */
    public void set_qos_coefficient_topology(iControl.GlobalLBPoolID[] pools, long[] values) throws java.rmi.RemoteException;

    /**
     * Sets the relative weight for virtual server capacity when the
     * load balancing
     *  mode is set to LB_METHOD_QOS. The default is 0.
     * 
     *  These weights help determine the importance of a given QoS (Quality
     * of Service)
     *  metric in calculating a score that is used to pick pool members.
     * For example,
     *  if you increase the RTT QoS coefficient on a given pool, the rtt
     * performance
     *  metric will have a larger effect on the overall scores of the pool's
     * pool
     *  members (ie pool members with better/lower rtts will now be more
     * likely to
     *  be picked).
     */
    public void set_qos_coefficient_vs_capacity(iControl.GlobalLBPoolID[] pools, long[] values) throws java.rmi.RemoteException;

    /**
     * Sets the relative weight for virtual server (VS) score when
     * the load balancing
     *  mode is set to LB_METHOD_QOS. The default is 0.
     * 
     *  These weights help determine the importance of a given QoS (Quality
     * of Service)
     *  metric in calculating a score that is used to pick pool members.
     * For example,
     *  if you increase the RTT QoS coefficient on a given pool, the rtt
     * performance
     *  metric will have a larger effect on the overall scores of the pool's
     * pool
     *  members (ie pool members with better/lower rtts will now be more
     * likely to
     *  be picked).
     */
    public void set_qos_coefficient_vs_score(iControl.GlobalLBPoolID[] pools, long[] values) throws java.rmi.RemoteException;

    /**
     * Sets the maximum number of answers to return for a given query
     * answered
     *  from the specified pools. The default value is 1 and the maximum
     * value
     *  is 16. Any answers returned beyond the first one are put in the
     *  additional records section of the response.
     * 
     *  For example, for an A or AAAA type query answered from a pool that
     * is
     *  set to return 2 answers, an IP address is added to the response in
     * the
     *  answer section and a second IP address is added to the additional
     * record
     *  section of the response. The types of answers returned will vary
     * with
     *  the type of the request.
     * 
     *  Note that for a CNAME type pool, setting the number of answers to
     * return
     *  to a value greater than 1 is not allowed and will result in an error.
     */
    public void set_returned_answers_count(iControl.GlobalLBPoolID[] pools, long[] answers) throws java.rmi.RemoteException;

    /**
     * Sets the TTL values for the specified pools.
     * 
     *  The TTL is the number of seconds that the answer is valid after
     *  it is found. When the TTL expires, the client has to request
     *  answer resolution again. The valid range for TTL is 0 though
     *  4294967295 seconds; the default TTL is 30 seconds.
     */
    public void set_ttl(iControl.GlobalLBPoolID[] pools, long[] values) throws java.rmi.RemoteException;

    /**
     * Sets the states to indicate whether to check the availability
     * of a pool member
     *  before using it.
     */
    public void set_verify_member_availability_state(iControl.GlobalLBPoolID[] pools, iControl.CommonEnabledState[] states) throws java.rmi.RemoteException;
}
