/**
 * SystemSessionPortType.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Jan 23, 2013 (02:07:54 PST) WSDL2Java emitter.
 */

package iControl;

public interface SystemSessionPortType extends java.rmi.Remote {

    /**
     * Gets the active folder.
     */
    public java.lang.String get_active_folder() throws java.rmi.RemoteException;

    /**
     * Gets the state for all future iControl SOAP requests whether
     * or not to
     *  process SOAP requests received with Document Type Definitions (DTDs).
     */
    public iControl.CommonEnabledState get_dtd_processing_state() throws java.rmi.RemoteException;

    /**
     * Gets the state for all future iControl SOAP requests that indicates
     * whether or not to force non-default iControl SOAP sessions to be
     *  established before SOAP requests are processed.
     */
    public iControl.CommonEnabledState get_force_sessions_state() throws java.rmi.RemoteException;

    /**
     * Gets the maximum number of user sessions.
     */
    public long get_maximum_sessions() throws java.rmi.RemoteException;

    /**
     * Gets the state to recursively query the contents of the active
     * folder.
     */
    public iControl.CommonEnabledState get_recursive_query_state() throws java.rmi.RemoteException;

    /**
     * Gets the type of path information returned with object names.
     */
    public iControl.SystemSessionReturnedPath get_returned_path() throws java.rmi.RemoteException;

    /**
     * Gets a new session identifier.
     * 
     *  This identifier is a value which uniquely identifies a user
     *  session.  Once retrieved by a client, it may be included in any
     *  subsequent requests to notify the iControl portal that a specific
     * request should be executed in the context of the session associated
     * with that identifier. 
     * 
     *  Use of this identifier is completely optional. If  it is not
     *  included in an iControl request, the session key defaults to the
     *  user name.  Note that this is even true if you have retrieved a
     *  unique session identifier.  It is also possible to have more than
     * one such unique session identifier active at the same time.
     *  However, it is important to understand that each session key,
     *  whether the unique identifier or the default user name represent
     *  distinct sessions.  Changing a session variable in one session does
     * not effect the variable in any other session.  On the other hand,
     *  if different clients have the same session key and one changes a
     *  session variable, the others will see it.  The important
     *  distinction is not the client being run and not the user running
     *  it, but the session key for each request. 
     * 
     *  When used, this session identifier must be passed to the iControl
     * portal via either an HTTP header or a SOAP header element.  There
     *  is no preference for which transport is used, as the portal will
     *  pick up either.  The client is free to use whichever is easier to
     * work with in the client's SOAP package.  If for some reason,
     *  conflicting values are set in the HTTP header and SOAP header
     *  element, the SOAP header element value will take precedence. 
     * 
     *  The HTTP header holding the session identifier is named
     *  "X-IControl-Session".  If used, its value must be set to the text
     * representation of the session identifier.  Thus in the HTTP
     *  request, the header would look like, e.g., X-iControl-Session: 14.
     * Most SOAP packages include a straightforward way to add an HTTP
     *  header to the HTTP request, so reference your documentation. 
     * 
     *  The SOAP header element is named "session".  If used, its value
     *  must be a SOAP integer element holding the session identifier. If
     * this client is intended to work with older versions of iControl, be
     * aware that the mustUnderstand SOAP header element attribute must be
     * set to 0.  Reference your SOAP package documentation for details
     *  for adding a SOAP header to a request.
     */
    public long get_session_identifier() throws java.rmi.RemoteException;

    /**
     * Gets the session timeout.
     */
    public long get_session_timeout() throws java.rmi.RemoteException;

    /**
     * Gets the transaction timeout.
     */
    public long get_transaction_timeout() throws java.rmi.RemoteException;

    /**
     * Gets the version information for this interface.
     */
    public java.lang.String get_version() throws java.rmi.RemoteException;

    /**
     * Roll back the transaction.
     * 
     *  When called, all of the requests submitted since start_transaction
     * was called are un-done.  The configuration will remain unchanged.
     * 
     * 
     *  If no transaction is open, an error is signaled.  If no requests
     *  have been queued in the transaction, nothing is done and no error
     * is signaled.
     */
    public void rollback_transaction() throws java.rmi.RemoteException;

    /**
     * Sets the active folder.
     * 
     *  Most configuration objects reside in folders (see the
     *  Management::Folder interface), but continually specifying the full
     * path to name an object can be wearing.  For ease, an "active
     *  folder" can be specified.  When creating or accessing objects and
     * a
     *  full object path is not specified (i.e., the object path does not
     * begin with a slash (/)), the active folder is prepended to the
     *  object name.  Thus if the name for an object to be created is
     *  specified as "repository-a" and the active folder is
     *  /george/server, the full path for the created object is
     *  /george/server/repository-a.  Note that relative paths are also
     *  allowed in the object identifier, so that if the active folder is
     * /george/server and the given object identifier is
     *  virtual/repository-a, then the full object path is
     *  /george/server/virtual/repository-a.
     * 
     *  The active folder may be the root folder (/), but that is only
     *  usable when querying.
     * 
     *  If for some reason, neither the currently active folder nor the
     *  newly requested active folder exist, the currently active folder
     *  will be set to the user's default folder.
     */
    public void set_active_folder(java.lang.String folder) throws java.rmi.RemoteException;

    /**
     * Sets the state for all future iControl SOAP requests whether
     * or not to
     *  process SOAP requests received with Document Type Definitions (DTDs).
     * This is set to STATE_DISABLED by default. Only administrators can
     * set
     *  this value. This was introduced in BIG-IP_v12.0.0 to conform to SOAP
     * specifications that disallow DTDs. SOAP requests that use DTDs will
     * return a "parsing aborted" error and not parse the request. This
     *  will also set the "iControl.DTDParsing" DB variable to "enable" or
     * "disable" respectively. If modifying the DB variable directly,
     *  restart httpd to make the changes go into effect.
     */
    public void set_dtd_processing_state(iControl.CommonEnabledState state) throws java.rmi.RemoteException;

    /**
     * Sets the state for all future iControl SOAP requests whether
     * or not to
     *  force non-default iControl SOAP sessions to be established before
     * SOAP requests are processed. This will disable the use of the default
     * session identifier (the username) and force the use of a system
     *  provided identifier received from a call to get_session_identifier.
     * This is set to STATE_DISABLED by default. Only
     *  administrators can set this value. This was introduced in
     *  BIG-IP_v12.0.0 to enable enhanced protections against CSRF attacks.
     * Any attempts to run a command without a session will return a
     *  "Could not find the iControl session for <user> error". Use caution
     * before turning this feature on as it may break existing SOAP clients,
     * many of which may not establish sessions before making requests. This
     * will also set the "iControl.ForceSessions" DB variable to "enable"
     * or
     *  "disable" respectively. If modifying the DB variable directly,
     *  restart httpd to make the changes go into effect.
     * 
     *  In order tune iControl SOAP sessions to your needs, see:
     *  get_session_identifier: which will return the session ID for
     *                          a given session.
     *  set_session_timeout:    which will set the amount of time a session
     * will
     *                          be in effect.
     *  set_maximum_sessions:   which will set the maximum number of concurrent
     * user sessions at any given time.
     */
    public void set_force_sessions_state(iControl.CommonEnabledState state) throws java.rmi.RemoteException;

    /**
     * Sets the maximum number of concurrent user sessions.
     * 
     *  A system could be attacked by creating an inordinate number of
     *  iControl user sessions, eventually bringing the iControl portal (or
     * the system itself) to a crawl.  If iControl is already supporting
     *  this number of user sessions, subsequent attempts to create a new
     * user sessions are rejected with an error.
     * 
     *  If this limit is set to zero, the number of user sessions is
     *  unlimited.  Only administrators can set this value.
     */
    public void set_maximum_sessions(long sessions) throws java.rmi.RemoteException;

    /**
     * Sets the state to recursively query the contents of the
     *  active folder. As of 11.4.0, this setting applies also to
     *  delete_all_x operations.
     * 
     *  If not set, any query will return objects in the active folder
     *  only.  If set, any query will return objects in the active folder,
     * plus objects in any sub-folders under that active folder no matter
     * how deeply nested.
     * 
     *  Note, regarding other recursive operations: when folders
     *  were introduced, the behavior of delete_all_x methods, such
     *  as LocalLB::Pool::delete_all_pools, was unspecified with
     *  respect to folders. (It was unspecified in which folders to
     *  apply the operation).  As of 11.4.0, the behavior of
     *  delete_all_x methods is clarified: delete_all_pools and
     *  similar methods operate on objects in the active folder,
     *  and only there. If you would like to delete all pools in
     *  the active folder and folders below it, enable recursive
     *  query using this method.  If you would like to delete all
     *  pools in a top-level folder (partition) and below, set the
     *  active folder to the desired folder and turn on recursive
     *  query.
     */
    public void set_recursive_query_state(iControl.CommonEnabledState state) throws java.rmi.RemoteException;

    /**
     * Sets the type of path information returned with object names.
     */
    public void set_returned_path(iControl.SystemSessionReturnedPath path) throws java.rmi.RemoteException;

    /**
     * Sets the session timeout.
     * 
     *  The session timeout is the amount of time for which a user session
     * has not processed a request before it is marked as eligible for
     *  deletion.  For a user session without a session identifier,
     *  re-using an expired session will trigger the creation of a new user
     * session with the default session values.  For a user session with
     * a
     *  session identifier, re-using an expired session will result in an
     * error.
     * 
     *  The session timeout is a global value, so it applies equally to all
     * user sessions.  A zero timeout means that only one request can be
     *  handled per user session, effectively turning off sessions.  Only
     * administrators can set this value.
     */
    public void set_session_timeout(long timeout) throws java.rmi.RemoteException;

    /**
     * Sets the transaction timeout, the amount of time that an open
     * transaction can be inactive before it is marked for deletion.
     * 
     *  This is effectively a lower limit, an inactive open transaction may
     * be open longer than that, though is effectively unusable after that
     * point.  Expiring transactions are logged.  The transaction timeout
     * is unique for each session.
     */
    public void set_transaction_timeout(long timeout) throws java.rmi.RemoteException;

    /**
     * Start an iControl transaction, which combines the effects of
     * a
     *  number of iControl methods into a single atomic transaction.
     * 
     *  Once an iControl client calls start_transaction, the handling of
     *  subsequent iControl requests changes until the client submits or
     *  rolls back the transaction, i.e. while the transaction is open. 
     * It
     *  is important to understand the characteristics of iControl requests
     * made in this mode.  iControl requests which modify the
     *  configuration are submitted for subsequent execution.  The requests
     * do not affect the configuration at the time they are made.
     *  iControl requests which query the configuration are executed
     *  immediately and do not see the effects of a pending transaction.
     *  iControl modify requests made outside a session with an open
     *  transaction affect the configuration immediately and do not see
     *  effects of any pending transactions.
     * 
     *  A transaction remains open until submit_transaction or
     *  rollback_transaction is called or until it is idle for too long.
     * 
     *  Reporting errors also differ while a transaction is open.  Some
     *  classes of errors (such as invalid arguments) are returned by the
     * method itself.  The context for these errors should thus be as
     *  clear as without a transaction.  However, most errors will be
     *  returned by the submit_transaction call.  Note that this can make
     * it difficult to determine which iControl method caused the error.
     *  If an error occurs at any time during a transaction, the
     *  transaction remains open, but is marked as errant.  When
     *  submit_transaction is subsequently called, the transaction will
     *  actually be deleted, as if rollback_transaction has been called.
     *  Note that even if an error occurs, submit_transaction or
     *  rollback_transaction still must be called to properly close it.
     * 
     *  Not all interfaces and methods support transactions.  These methods
     * are processed per normal, i.e., executed immediately and not as
     *  part of the transaction. The documentation includes a note for
     *  those interfaces and methods which do not. 
     * 
     *  The contents of pending transaction cannot be queried or modified.
     * Only one transaction can be open at the same time in a single
     *  user session.
     */
    public long start_transaction() throws java.rmi.RemoteException;

    /**
     * Submit the transaction for execution.
     * 
     *  When called, all of the requests submitted since start_transaction
     * was called are committed to the configuration as a single atomic
     *  transaction.  If all of the requests succeed, the configuration is
     * updated.  If any of the requests fail, the transaction as a whole
     *  fails and the configuration remains unchanged. 
     * 
     *  If an error is signaled, it may be from any of the submitted
     *  requests.  Nothing outside the returned error message can indicate
     * which request triggered the error.  If no requests have been queued
     * in the transaction, nothing is done and no error is signaled.   If
     * no transaction is open, an error is signaled.
     */
    public void submit_transaction() throws java.rmi.RemoteException;
}
