/**
 * NetworkingDNSResolverPortType.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Jan 23, 2013 (02:07:54 PST) WSDL2Java emitter.
 */

package iControl;

public interface NetworkingDNSResolverPortType extends java.rmi.Remote {

    /**
     * Adds the specified forward zones to the specified DNS resolvers.
     */
    public void add_forward_zone(java.lang.String[] resolvers, java.lang.String[][] zones) throws java.rmi.RemoteException;

    /**
     * Adds the specified nameservers to a set of forward zones for
     * the specified DNS
     *  resolvers.
     */
    public void add_nameserver(java.lang.String[] resolvers, java.lang.String[][] zones, iControl.CommonIPPortDefinition[][][] nameservers) throws java.rmi.RemoteException;

    /**
     * Creates a set of DNS resolvers.
     */
    public void create(java.lang.String[] resolvers) throws java.rmi.RemoteException;

    /**
     * Deletes all DNS resolvers.
     */
    public void delete_all_dns_resolvers() throws java.rmi.RemoteException;

    /**
     * Deletes a set of DNS resolvers.
     */
    public void delete_dns_resolver(java.lang.String[] resolvers) throws java.rmi.RemoteException;

    /**
     * Gets whether the system answers DNS queries for the default
     * zones (localhost,
     *  reverse 127.0.0.1 and ::1, and AS112) for a set of DNS resolvers.
     */
    public iControl.CommonEnabledState[] get_answer_default_zones_state(java.lang.String[] resolvers) throws java.rmi.RemoteException;

    /**
     * Gets the sizes of the internal DNS resolver cache for a set
     * of DNS resolvers.
     */
    public long[] get_cache_size(java.lang.String[] resolvers) throws java.rmi.RemoteException;

    /**
     * Gets the names of forward zones for the specified DNS resolvers.
     * 
     *  A given zone name should only use the symbols allowed for a fully
     * qualified
     *  domain name (FQDN), namely ASCII letters 'a' though 'z', digits '0'
     * through '9',
     *  hyphen '-', and period '.'. For example 'site.example.com' would
     * be a valid
     *  zone name.
     * 
     *  A DNS resolver configured with a forward zone will forward any queries
     * that
     *  resulted in a cache-miss (because the answer was not available in
     * the cache)
     *  and which also match a configured zone name, to the nameserver specified
     * on
     *  the zone. If no nameservers are specified on the zone, an automatic
     * SERVFAIL
     *  is returned. When a forward zone's nameserver returns a valid response
     * to
     *  the DNS resolver, that response is cached and then returned to the
     * requestor.
     */
    public java.lang.String[][] get_forward_zone(java.lang.String[] resolvers) throws java.rmi.RemoteException;

    /**
     * Gets a list of names for all DNS resolvers.
     */
    public java.lang.String[] get_list() throws java.rmi.RemoteException;

    /**
     * Gets the nameservers for the specified forward zones for the
     * specified DNS
     *  resolvers.
     * 
     *  If more than one nameserver is configured for a given forward zone,
     * a matching
     *  query will be sent to the nameserver that is currently deemed the
     * most
     *  responsive, based on RTTs. Configuring multiple nameservers allows
     * the system
     *  to automatically recover when there is a non-responsive server.
     */
    public iControl.CommonIPPortDefinition[][][] get_nameserver(java.lang.String[] resolvers, java.lang.String[][] zones) throws java.rmi.RemoteException;

    /**
     * Gets whether to randomly vary the case of letters in domain
     * names queried
     *  for a set of DNS resolvers.
     */
    public iControl.CommonEnabledState[] get_randomize_query_character_case_state(java.lang.String[] resolvers) throws java.rmi.RemoteException;

    /**
     * Gets the route domains for a set of DNS resolvers.
     */
    public java.lang.String[] get_route_domain(java.lang.String[] resolvers) throws java.rmi.RemoteException;

    /**
     * Gets whether IPv4 can be used for issuing queries for a set
     * of DNS resolvers.
     */
    public iControl.CommonEnabledState[] get_use_ipv4_state(java.lang.String[] resolvers) throws java.rmi.RemoteException;

    /**
     * Gets whether IPv6 can be used for issuing queries for a set
     * of DNS resolvers.
     */
    public iControl.CommonEnabledState[] get_use_ipv6_state(java.lang.String[] resolvers) throws java.rmi.RemoteException;

    /**
     * Gets whether TCP can be used for issuing queries for a set
     * of DNS resolvers.
     */
    public iControl.CommonEnabledState[] get_use_tcp_state(java.lang.String[] resolvers) throws java.rmi.RemoteException;

    /**
     * Gets whether UDP can be used for issuing queries for a set
     * of DNS resolvers.
     */
    public iControl.CommonEnabledState[] get_use_udp_state(java.lang.String[] resolvers) throws java.rmi.RemoteException;

    /**
     * Get the version information for this interface.
     */
    public java.lang.String get_version() throws java.rmi.RemoteException;

    /**
     * Removes all forward zones from the specified DNS resolvers.
     */
    public void remove_all_forward_zones(java.lang.String[] resolvers) throws java.rmi.RemoteException;

    /**
     * Removes all nameservers from the specified forward zones for
     * the specified DNS
     *  resolvers.
     */
    public void remove_all_nameservers(java.lang.String[] resolvers, java.lang.String[][] zones) throws java.rmi.RemoteException;

    /**
     * Removes the specified forward zones from the specified DNS
     * resolvers.
     */
    public void remove_forward_zone(java.lang.String[] resolvers, java.lang.String[][] zones) throws java.rmi.RemoteException;

    /**
     * Removes the specified nameservers from the specified forward
     * zones for the
     *  specified DNS resolvers.
     */
    public void remove_nameserver(java.lang.String[] resolvers, java.lang.String[][] zones, iControl.CommonIPPortDefinition[][][] nameservers) throws java.rmi.RemoteException;

    /**
     * Sets whether the resolver answers DNS queries for the default
     * zones (localhost,
     *  reverse 127.0.0.1 and ::1, and AS112) for a set of DNS resolvers.
     * The default value
     *  is disabled, meaning that the system passes along the DNS queries
     * for the default
     *  zone.
     */
    public void set_answer_default_zones_state(java.lang.String[] resolvers, iControl.CommonEnabledState[] states) throws java.rmi.RemoteException;

    /**
     * Sets the sizes of the internal DNS resolver cache for a set
     * of DNS resolvers.
     *  After the cache reaches this size, when new or refreshed content
     * arrives,
     *  the system removes expired and older content and caches the new or
     * updated
     *  content. The default is 5767168 bytes.
     */
    public void set_cache_size(java.lang.String[] resolvers, long[] sizes) throws java.rmi.RemoteException;

    /**
     * Sets whether to randomly vary the case of letters in domain
     * names queried
     *  for a set of DNS resolvers.
     * 
     *  If disabled, the resolver will not vary the case of letters in domain
     * names
     *  queried.
     * 
     *  The DNS standards require that nameservers treat query names case-insensitively.
     * Domain names with the same letters, regardless of the case, should
     * resolve to the
     *  same IP address. On the other hand, for the response, nameservers
     * should preserve
     *  the original case that appeared in the request. This technique will
     * help to
     *  reduce the risk of cache poisioning. The default value is enabled.
     */
    public void set_randomize_query_character_case_state(java.lang.String[] resolvers, iControl.CommonEnabledState[] states) throws java.rmi.RemoteException;

    /**
     * Sets the route domains for a set of DNS resolvers.
     * 
     *  A resolver will use the specified route domain for any outbound DNS
     * traffic.
     *  The default value is the default route domain specified in the network
     * route
     *  domain configuration.
     */
    public void set_route_domain(java.lang.String[] resolvers, java.lang.String[] domains) throws java.rmi.RemoteException;

    /**
     * Sets whether IPv4 can be used for issuing queries for a set
     * of DNS resolvers.
     * 
     *  If disabled, the resolver will not attempt to resolve queries using
     * IPv4.
     * 
     *  IPv4 and IPv6 cannot be disabled simultaneously. There may be a case
     * where one
     *  is enabled and the other disabled and you want to swap their states.
     * To toggle
     *  these, both must be enabled first, or a transaction must be used.
     * The default
     *  value is enabled.
     */
    public void set_use_ipv4_state(java.lang.String[] resolvers, iControl.CommonEnabledState[] states) throws java.rmi.RemoteException;

    /**
     * Sets whether IPv6 can be used for issuing queries for a set
     * of DNS resolvers.
     * 
     *  If disabled, the resolver will not attempt to resolve queries using
     * IPv6.
     * 
     *  IPv4 and IPv6 cannot be disabled simultaneously. There may be a case
     * where one
     *  is enabled and the other disabled and you want to swap their states.
     * To toggle
     *  these, both must be enabled first, or a transaction must be used.
     * The default
     *  value is enabled.
     */
    public void set_use_ipv6_state(java.lang.String[] resolvers, iControl.CommonEnabledState[] states) throws java.rmi.RemoteException;

    /**
     * Sets whether TCP can be used for issuing queries for a set
     * of DNS resolvers.
     * 
     *  If disabled, the resolver will not attempt to resolve queries over
     * TCP.
     * 
     *  UDP and TCP cannot be disabled simultaneously. There may be a case
     * where one is
     *  enabled and the other disabled and you want to swap their states.
     * To toggle
     *  these, both must be enabled first, or a transaction must be used.
     * The default
     *  value is enabled.
     */
    public void set_use_tcp_state(java.lang.String[] resolvers, iControl.CommonEnabledState[] states) throws java.rmi.RemoteException;

    /**
     * Sets whether UDP can be used for issuing queries for a set
     * of DNS resolvers.
     * 
     *  If disabled, the resolver will not attempt to resolve queries over
     * UDP.
     * 
     *  UDP and TCP cannot be disabled simultaneously. There may be a case
     * where one is
     *  enabled and the other disabled and you want to swap their states.
     * To toggle
     *  these, both must be enabled first, or a transaction must be used.
     * The default
     *  value is enabled.
     */
    public void set_use_udp_state(java.lang.String[] resolvers, iControl.CommonEnabledState[] states) throws java.rmi.RemoteException;
}
