/**
 * LocalLBDNSCachePortType.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Jan 23, 2013 (02:07:54 PST) WSDL2Java emitter.
 */

package iControl;

public interface LocalLBDNSCachePortType extends java.rmi.Remote {

    /**
     * Adds DNSSEC Lookaside Validation (DLV) anchors for a set of
     * DNS caches.
     */
    public void add_dlv_anchor(java.lang.String[] caches, java.lang.String[][] anchors) throws java.rmi.RemoteException;

    /**
     * Adds the specified forward zones for a set of DNS caches.
     */
    public void add_forward_zone(java.lang.String[] caches, java.lang.String[][] zones) throws java.rmi.RemoteException;

    /**
     * Adds the specified nameservers for a set of forward zones on
     * a set of DNS caches.
     */
    public void add_nameserver(java.lang.String[] caches, java.lang.String[][] zones, iControl.CommonIPPortDefinition[][][] nameservers) throws java.rmi.RemoteException;

    /**
     * Adds the specified response policy zone for a set of DNS caches.
     * 
     *  A DNS Cache configured with a response policy zone checks the query
     * name
     *  in a DNS request as well as information in the response against the
     * data
     *  in the configured zones.  If a match is found, the DNS response is
     * modified
     *  according to the configured action.  For example, if the action is
     * NXDOMAIN,
     *  the request is modified to give an NXDOMAIN result.
     */
    public void add_response_policy_zone(java.lang.String[] caches, java.lang.String[][] zones, iControl.LocalLBRPZActionType[][] actions, java.lang.String[][] walled_gardens) throws java.rmi.RemoteException;

    /**
     * Adds root hints for a set of DNS caches.
     */
    public void add_root_hint(java.lang.String[] caches, java.lang.String[][] hints) throws java.rmi.RemoteException;

    /**
     * Adds to the DNSSEC validator trust anchors for a set of DNS
     * caches.
     */
    public void add_trust_anchor(java.lang.String[] caches, java.lang.String[][] anchors) throws java.rmi.RemoteException;

    /**
     * Creates the specified DNS caches.
     */
    public void create(java.lang.String[] caches, iControl.LocalLBDNSCacheType[] types) throws java.rmi.RemoteException;

    /**
     * Deletes all DNS caches.
     */
    public void delete_all_dns_caches() throws java.rmi.RemoteException;

    /**
     * Deletes all DNSSEC key records for a set of DNS caches.
     */
    public void delete_all_key_records(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Deletes all DNS message records for a set of DNS caches.
     */
    public void delete_all_message_records(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Deletes all nameserver records for a set of DNS caches.
     */
    public void delete_all_nameserver_records(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Deletes all resource records for a set of DNS caches.
     */
    public void delete_all_resource_records(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Deletes the specified DNS caches.
     */
    public void delete_dns_cache(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets the allowed query time for a set of DNS caches.
     */
    public long[] get_allowed_query_time(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets whether a set of DNS caches answer default zones.
     */
    public iControl.CommonEnabledState[] get_answer_default_zones_state(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets the descriptions for a set of DNS caches.
     */
    public java.lang.String[] get_description(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets the DNSSEC Lookaside Validation (DLV) anchors for a set
     * of DNS caches.
     * 
     *  These are in the form of dig output.  For example, run the command:
     * dig
     */
    public java.lang.String[][] get_dlv_anchor(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets the names of forward zones for a set of DNS caches.
     * 
     *  A given zone name should only use the symbols allowed for a fully
     * qualified 
     *  domain name (FQDN), namely ASCII letters 'a' though 'z', digits '0'
     * through '9', 
     *  hyphen '-', and period '.'. For example 'site.example.com' would
     * be a valid 
     *  zone name.
     * 
     *  A DNS Cache configured with a forward zone will forward any queries
     * that 
     *  resulted in a cache-miss (because the answer was not available in
     * the cache) 
     *  and which also match a configured zone name, to the nameserver specified
     * on 
     *  the zone. If no nameservers are specified on the zone, an automatic
     * SERVFAIL 
     *  is returned. When a forward zone's nameserver returns a valid response
     * to 
     *  the DNS Cache, that response is cached and then returned to the requestor.
     */
    public java.lang.String[][] get_forward_zone(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets whether to ignore the checking disabled bit for a set
     * of DNS caches.
     */
    public iControl.CommonEnabledState[] get_ignore_cd_state(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets the size in bytes of the DNSSEC key cache for a set of
     * DNS caches.
     */
    public long[] get_key_cache_size(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets a list of DNS cache names.
     */
    public java.lang.String[] get_list() throws java.rmi.RemoteException;

    /**
     * Gets the local zone data for a set of DNS caches.
     */
    public iControl.LocalLBDNSCacheLocalZone[][] get_local_zone(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets the maximum concurrent distinct queries for a set of DNS
     * caches.
     */
    public long[] get_maximum_concurrent_queries(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets the maximum concurrent TCP flows for a set of DNS caches.
     */
    public long[] get_maximum_tcp_flows(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets the maximum concurrent TCP flows for a set of DNS caches.
     */
    public long[] get_maximum_udp_flows(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets the size in bytes of the message cache for a set of DNS
     * caches.
     */
    public long[] get_message_cache_size(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets the nameservers for the specified forward zones on a set
     * of DNS caches.
     * 
     *  If more than one nameserver is listed for a given forward zone, a
     * matching query 
     *  will be sent to the nameserver that is currently deemed the most
     * responsive, based 
     *  on RTTs. If no response is received within a certain window of time,
     * the DNS Cache 
     *  will resend the query to another nameserver with an increased wait
     * window, until a 
     *  response is received.
     */
    public iControl.CommonIPPortDefinition[][][] get_nameserver(java.lang.String[] caches, java.lang.String[][] zones) throws java.rmi.RemoteException;

    /**
     * Gets the maximum number of name server cache entries for a
     * set of DNS caches.
     */
    public long[] get_nameserver_cache_count(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets whether a set of validating-resolver DNS caches will prefetch
     * DNSSEC keys.
     */
    public iControl.CommonEnabledState[] get_prefetch_key_state(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets whether to randomly vary the case of letters in domain
     * names for a set of DNS caches.
     */
    public iControl.CommonEnabledState[] get_randomize_query_name_case_state(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets the size in bytes of the resource record cache for a set
     * of DNS caches.
     */
    public long[] get_resource_record_cache_size(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets the response policy zones for a set of DNS caches.
     */
    public java.lang.String[][] get_response_policy_zone(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets the response policy zone actions for a set of DNS caches
     * and zones.
     */
    public iControl.LocalLBRPZActionType[][] get_response_policy_zone_action(java.lang.String[] caches, java.lang.String[][] zones) throws java.rmi.RemoteException;

    /**
     * Gets the response policy zone walled garden for a set of DNS
     * caches and zones.
     */
    public java.lang.String[][] get_response_policy_zone_walled_garden(java.lang.String[] caches, java.lang.String[][] zones) throws java.rmi.RemoteException;

    /**
     * Gets the root hints for a set of DNS caches.
     */
    public java.lang.String[][] get_root_hint(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets the route domain for a set of DNS caches.
     */
    public java.lang.String[] get_route_domain(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets the statistics for a set of DNS caches.
     */
    public iControl.LocalLBDNSCacheDNSCacheStatistics get_statistics(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets the DNSSEC validator trust anchors for a set of DNS caches.
     * 
     *  These are in the form of dig output.  For example, run the command:
     * 
     *   dig
     */
    public java.lang.String[][] get_trust_anchor(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets the cache types for a set of DNS caches.
     */
    public iControl.LocalLBDNSCacheType[] get_type(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets the size of the unwanted reply threshold for a set of
     * DNS caches.
     */
    public long[] get_unwanted_reply_threshold(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets whether to use IPv4 for a set of DNS caches.
     */
    public iControl.CommonEnabledState[] get_use_ipv4_state(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets whether to use IPv6 for a set of DNS caches.
     */
    public iControl.CommonEnabledState[] get_use_ipv6_state(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets whether to use TCP for a set of DNS caches.
     */
    public iControl.CommonEnabledState[] get_use_tcp_state(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Gets whether to use UDP for a set of DNS caches.
     */
    public iControl.CommonEnabledState[] get_use_udp_state(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Get the version information for this interface.
     */
    public java.lang.String get_version() throws java.rmi.RemoteException;

    /**
     * Removes all DNSSEC Lookaside Validation (DLV) anchors for a
     * set of DNS caches.
     */
    public void remove_all_dlv_anchors(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Removes all forward zones for a set of DNS caches.
     */
    public void remove_all_forward_zones(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Removes all local zone data for a set of DNS caches.
     */
    public void remove_all_local_zones(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Removes all nameservers for the specified forward zones on
     * a set of DNS caches.
     */
    public void remove_all_nameservers(java.lang.String[] caches, java.lang.String[][] zones) throws java.rmi.RemoteException;

    /**
     * Removes all response policy zones for a set of DNS caches.
     */
    public void remove_all_response_policy_zones(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Removes all root hints for a set of DNS caches.
     */
    public void remove_all_root_hints(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Removes all DNSSEC validator trust anchors for a set of DNS
     * caches.
     */
    public void remove_all_trust_anchors(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Removes DNSSEC Lookaside Validation (DLV) anchors for a set
     * of DNS caches.
     */
    public void remove_dlv_anchor(java.lang.String[] caches, java.lang.String[][] anchors) throws java.rmi.RemoteException;

    /**
     * Removes the specified forward zones for a set of DNS caches.
     */
    public void remove_forward_zone(java.lang.String[] caches, java.lang.String[][] zones) throws java.rmi.RemoteException;

    /**
     * Removes the specified nameservers for a set of forward zones
     * on a set of DNS caches.
     */
    public void remove_nameserver(java.lang.String[] caches, java.lang.String[][] zones, iControl.CommonIPPortDefinition[][][] nameservers) throws java.rmi.RemoteException;

    /**
     * Removes the specified response policy zone for a set of DNS
     * caches.
     */
    public void remove_response_policy_zone(java.lang.String[] caches, java.lang.String[][] zones) throws java.rmi.RemoteException;

    /**
     * Removes the specified root hints for a set of DNS caches.
     */
    public void remove_root_hint(java.lang.String[] caches, java.lang.String[][] hints) throws java.rmi.RemoteException;

    /**
     * Removes DNSSEC validator trust anchors for a set of DNS caches.
     */
    public void remove_trust_anchor(java.lang.String[] caches, java.lang.String[][] anchors) throws java.rmi.RemoteException;

    /**
     * Replaces the local zone for a set of DNS caches.
     */
    public void replace_local_zone(java.lang.String[] caches, iControl.LocalLBDNSCacheLocalZone[][] zones) throws java.rmi.RemoteException;

    /**
     * Resets the statistics for a set of DNS caches.
     */
    public void reset_statistics(java.lang.String[] caches) throws java.rmi.RemoteException;

    /**
     * Sets the allowed query time for a set of DNS caches.
     * 
     *  This is used set the time allowed for a query to stay in the queue
     * before replaced by a new query when the number of concurrrent
     *  distinct queries exceeds the limit.
     */
    public void set_allowed_query_time(java.lang.String[] caches, long[] times) throws java.rmi.RemoteException;

    /**
     * Sets whether a set of DNS caches answer default zones.
     */
    public void set_answer_default_zones_state(java.lang.String[] caches, iControl.CommonEnabledState[] states) throws java.rmi.RemoteException;

    /**
     * Sets the description for a set of DNS caches.
     * 
     *  This is an arbitrary field which can be used for any purpose.
     */
    public void set_description(java.lang.String[] caches, java.lang.String[] descriptions) throws java.rmi.RemoteException;

    /**
     * Sets whether to ignore the checking disabled (CD) bit for a
     * set of DNS caches.
     */
    public void set_ignore_cd_state(java.lang.String[] caches, iControl.CommonEnabledState[] states) throws java.rmi.RemoteException;

    /**
     * Sets the size in bytes of the DNSSEC key cache for a set of
     * DNS caches.
     * 
     *  The cache will be initiated and maintained with this amount of memory
     * regardless of the number of entries.  If more space is needed, the
     * 
     *  cache will evict older but valid entries.
     */
    public void set_key_cache_size(java.lang.String[] caches, long[] sizes) throws java.rmi.RemoteException;

    /**
     * Sets the maximum concurrent distinct queries for a set of DNS
     * caches.
     * 
     *  This is used to limit the number of concurrent distinct queries that
     * a
     *  resolver allows. A query is identified by query name, type, and class.
     */
    public void set_maximum_concurrent_queries(java.lang.String[] caches, long[] queries) throws java.rmi.RemoteException;

    /**
     * Sets the maximum concurrent TCP flows for a set of DNS caches.
     * 
     *  This is used to limit the number of simultaneous outbound 
     *  TCP connections that a resolver can use to query DNS servers.
     */
    public void set_maximum_tcp_flows(java.lang.String[] caches, long[] flows) throws java.rmi.RemoteException;

    /**
     * Sets the maximum concurrent UDP flows for a set of DNS caches.
     * 
     *  This is used to limit the number of simultaneous outbound 
     *  UDP connections that a resolver can use to query DNS servers.
     */
    public void set_maximum_udp_flows(java.lang.String[] caches, long[] flows) throws java.rmi.RemoteException;

    /**
     * Sets the size in bytes of the message cache for a set of DNS
     * caches.
     * 
     *  The cache will be initiated and maintained with this amount of memory
     * regardless of the number of entries.  If more space is needed, the
     * 
     *  cache will evict older but valid entries.
     */
    public void set_message_cache_size(java.lang.String[] caches, long[] sizes) throws java.rmi.RemoteException;

    /**
     * Sets the maximum number of name server cache entries for a
     * set of DNS caches.
     */
    public void set_nameserver_cache_count(java.lang.String[] caches, long[] counts) throws java.rmi.RemoteException;

    /**
     * Sets whether a set of validating-resolver DNS caches will prefetch
     * DNSSEC keys.
     */
    public void set_prefetch_key_state(java.lang.String[] caches, iControl.CommonEnabledState[] states) throws java.rmi.RemoteException;

    /**
     * Sets whether to randomly vary the case of letters in domain
     * names
     *  queried for a set of DNS caches.
     * 
     *  If disabled, the resolver will not vary the case of letters in
     *  domain names queried.
     * 
     *  The DNS standards require that nameservers treat query
     *  names case-insensitively. Domain names with the same
     *  letter, regardless of the case, should resolve to the same
     *  IP address. On the other hand, for the response,
     *  nameservers should preserve the original case that appeared
     *  in the request. This technique will help to reduce the risk
     *  of cache poisioning.
     */
    public void set_randomize_query_name_case_state(java.lang.String[] caches, iControl.CommonEnabledState[] states) throws java.rmi.RemoteException;

    /**
     * Sets the size in bytes of the resource record cache for a set
     * of DNS caches.
     * 
     *  The cache will be initiated and maintained with this amount of memory
     * regardless of the number of entries.  If more space is needed, the
     * 
     *  cache will evict older but valid entries.
     */
    public void set_resource_record_cache_size(java.lang.String[] caches, long[] sizes) throws java.rmi.RemoteException;

    /**
     * Sets the route domain for a set of DNS caches.
     * 
     *  A resolver will use the specified route domain for any outbound 
     *  DNS traffic.
     */
    public void set_route_domain(java.lang.String[] caches, java.lang.String[] domains) throws java.rmi.RemoteException;

    /**
     * Sets the size of the unwanted reply threshold for a set of
     * DNS 
     *  caches.
     * 
     *  The threshold is the number of replies received to DNS queries which
     * were not initiated by the cache and may indicate a DNS attack. If
     * the 
     *  threshold is hit, an SNMP trap and log message are generated. The
     * 
     *  default is 0.
     */
    public void set_unwanted_reply_threshold(java.lang.String[] caches, long[] thresholds) throws java.rmi.RemoteException;

    /**
     * Sets whether to use IPv4 for a set of DNS caches. 
     * 
     *  If disabled, the resolver will not attempt to resolve queries using
     * 
     *  IPv4.
     * 
     *  IPv4 and IPv6 cannot be disabled simultaneously. There may be a case
     * where one is enabled and the other disabled and you want to swap
     *  their states. To toggle these, both must be enabled first, or a
     *  transaction must be used.
     */
    public void set_use_ipv4_state(java.lang.String[] caches, iControl.CommonEnabledState[] states) throws java.rmi.RemoteException;

    /**
     * Sets whether to use IPv6 for a set of DNS caches.
     * 
     *  If disabled, the resolver will not attempt to resolve queries using
     * 
     *  IPv6.
     * 
     *  IPv4 and IPv6 cannot be disabled simultaneously. There may be a case
     * where one is enabled and the other disabled and you want to swap
     *  their states. To toggle these, both must be enabled first, or a
     *  transaction must be used.
     */
    public void set_use_ipv6_state(java.lang.String[] caches, iControl.CommonEnabledState[] states) throws java.rmi.RemoteException;

    /**
     * Sets whether to use TCP for a set of DNS caches.
     * 
     *  If disabled, the resolver will not attempt to resolve queries over
     * 
     *  TCP. 
     * 
     *  UDP and TCP cannot be disabled simultaneously. There may be a case
     * where one is enabled and the other disabled and you want to swap
     *  their states. To toggle these, both must be enabled first, or a
     *  transaction must be used.
     */
    public void set_use_tcp_state(java.lang.String[] caches, iControl.CommonEnabledState[] states) throws java.rmi.RemoteException;

    /**
     * Sets whether to use UDP for a set of DNS caches. 
     * 
     *  If disabled, the resolver will not attempt to resolve queries over
     * 
     *  UDP. 
     * 
     *  UDP and TCP cannot be disabled simultaneously. There may be a case
     * where one is enabled and the other disabled and you want to swap
     *  their states. To toggle these, both must be enabled first, or a
     *  transaction must be used.
     */
    public void set_use_udp_state(java.lang.String[] caches, iControl.CommonEnabledState[] states) throws java.rmi.RemoteException;
}
