/**
 * ManagementTrustPortType.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Jan 23, 2013 (02:07:54 PST) WSDL2Java emitter.
 */

package iControl;

public interface ManagementTrustPortType extends java.rmi.Remote {

    /**
     * Add an authoritative device to the trust domain.
     * 
     *  You must specify a new device object name for
     *  the device to be added.
     * 
     *  You may specify various arguments to authenticate
     *  the browser certificate of the device being added.  Any or
     *  all of these values may be omitted.
     * 
     *  Note: Currently, the backend requires hexadecimal values
     *  to be in lower case and not include the ':' character.
     */
    public void add_authority_device(java.lang.String address, java.lang.String username, java.lang.String password, java.lang.String device_object_name, java.lang.String browser_cert_serial_number, java.lang.String browser_cert_signature, java.lang.String browser_cert_sha1_fingerprint, java.lang.String browser_cert_md5_fingerprint) throws java.rmi.RemoteException;

    /**
     * Add a non-authoritative device to the trust domain.
     * 
     *  You must specify a new device object name for the device
     *  to be added.
     * 
     *  You may specify various arguments to authenticate
     *  the browser certificate of the device being added.  Any or
     *  all of these values may be omitted.
     * 
     *  Note: Currently, the backend requires hexadecimal values
     *  to be in lower case and not include the ':' character.
     */
    public void add_non_authority_device(java.lang.String address, java.lang.String username, java.lang.String password, java.lang.String device_object_name, java.lang.String browser_cert_serial_number, java.lang.String browser_cert_signature, java.lang.String browser_cert_sha1_fingerprint, java.lang.String browser_cert_md5_fingerprint) throws java.rmi.RemoteException;

    /**
     * Generates a certificate signing request for a device identity
     * certificate
     * 
     *  Note: This method is mostly for internal F5 use.
     */
    public java.lang.String generate_csr(java.lang.String device) throws java.rmi.RemoteException;

    /**
     * Get information about the browser certificate for the device
     * at the given address.
     * 
     *  This information will be used later in the get_device_name,
     *  add_non_authority_device, and add_authority_device calls.
     */
    public iControl.ManagementTrustBrowserCertificateInfo get_browser_certificate(java.lang.String address) throws java.rmi.RemoteException;

    /**
     * Get the PEM encoded CA certificate for this device.
     */
    public java.lang.String get_ca_certificate() throws java.rmi.RemoteException;

    /**
     * Used to check to see if a device is 'in use' by the current
     * trust domain.
     *  A device is considered to be in use if the device trust/logical devices
     * are
     *  configured in such a way that the device may be actively passing
     * traffic for
     *  the current trust domain
     * 
     *  Note: This method is mostly for internal F5 use.
     */
    public boolean get_device_in_use() throws java.rmi.RemoteException;

    /**
     * Get the device object name for the device at the given address.
     * 
     *  You may specify various arguments to authenticate the
     *  browser certificate of the device being added.  Any or all
     *  of these values may be omitted.
     * 
     *  Note: Currently, the backend requires hexadecimal values
     *  to be in lower case and not include the ':' character.
     */
    public java.lang.String get_device_object_name(java.lang.String address, java.lang.String username, java.lang.String password, java.lang.String browser_cert_serial_number, java.lang.String browser_cert_signature, java.lang.String browser_cert_sha1_fingerprint, java.lang.String browser_cert_md5_fingerprint) throws java.rmi.RemoteException;

    /**
     * Get the GUID attribute for the specified trust domains.
     *  Used to determine when devices are in the same trust domain.
     */
    public java.lang.String[] get_guid(java.lang.String[] domains) throws java.rmi.RemoteException;

    /**
     * Get the list of trust domains.
     *  BIG-IP 11.0.0 through 11.3.0 support only the root trust domain
     *  but the system supports multiple trust domains for future
     *  functionality.
     */
    public java.lang.String[] get_list() throws java.rmi.RemoteException;

    /**
     * Gets the interface version
     */
    public java.lang.String get_version() throws java.rmi.RemoteException;

    /**
     * Install certificates and add the device as a peer authority
     * to a trust domain.
     * 
     *  Note: This method is mostly for internal F5 use.
     */
    public void install_authority_trust(java.lang.String device, java.lang.String identity_cert, java.lang.String ca_cert, java.lang.String ca_key, java.lang.String[] authorities, java.lang.String[] management_addresses, java.lang.String[] configsync_addresses) throws java.rmi.RemoteException;

    /**
     * Install certificates and add the device as a non-authority
     * to a trust domain.
     * 
     *  Note: This method is mostly for internal F5 use.
     */
    public void install_device_trust(java.lang.String device, java.lang.String identity_cert, java.lang.String ca_cert, java.lang.String[] authorities, java.lang.String[] management_addresses, java.lang.String[] configsync_addresses) throws java.rmi.RemoteException;

    /**
     * Remove the specified devices from the trust domain.
     */
    public void remove_device(java.lang.String[] devices) throws java.rmi.RemoteException;

    /**
     * Reset the trust domain on the local device.
     * 
     *  This call causes the trust domain on the local device to
     *  be cleared.  You may choose to keep the current device
     *  object name and authority cert/key pair.  Alternately, you
     *  may specify a new device object name and may have the
     *  authority cert/key pair regenerated or set to the values
     *  specified in the authority_cert and
     *  authority_key parameters.
     * 
     *  Note: all known devices (accept for self) will be removed from
     *  the trust domain.
     */
    public void reset_all(java.lang.String device_object_name, boolean keep_current_authority, java.lang.String authority_cert, java.lang.String authority_key) throws java.rmi.RemoteException;
}
